'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _addSticker = require('./modifiers/addSticker');

var _addSticker2 = _interopRequireDefault(_addSticker);

var _removeSticker = require('./modifiers/removeSticker');

var _removeSticker2 = _interopRequireDefault(_removeSticker);

var _cleanupEmptyStickers = require('./modifiers/cleanupEmptyStickers');

var _cleanupEmptyStickers2 = _interopRequireDefault(_cleanupEmptyStickers);

var _blockRendererFn = require('./blockRendererFn');

var _blockRendererFn2 = _interopRequireDefault(_blockRendererFn);

var _Sticker = require('./Sticker');

var _Sticker2 = _interopRequireDefault(_Sticker);

var _StickerSelect = require('./StickerSelect');

var _StickerSelect2 = _interopRequireDefault(_StickerSelect);

var _decorateComponentWithProps = require('decorate-component-with-props');

var _decorateComponentWithProps2 = _interopRequireDefault(_decorateComponentWithProps);

var _stickerStyles = {
  "sticker": "draftJsStickerPlugin__sticker__2_vBJ",
  "stickerRemoveButton": "draftJsStickerPlugin__stickerRemoveButton__2vzbk",
  "stickerImage": "draftJsStickerPlugin__stickerImage__2X3Cm"
};

var _stickerStyles2 = _interopRequireDefault(_stickerStyles);

var _selectStyles = {
  "select": "draftJsStickerPlugin__select__30KbO",
  "selectPopover": "draftJsStickerPlugin__selectPopover__20IIM",
  "selectClosedPopover": "draftJsStickerPlugin__selectClosedPopover__1UXVa",
  "selectButton": "draftJsStickerPlugin__selectButton__3voOt",
  "selectPressedButton": "draftJsStickerPlugin__selectPressedButton__1xYeW draftJsStickerPlugin__selectButton__3voOt",
  "selectBottomGradient": "draftJsStickerPlugin__selectBottomGradient__1DA_0",
  "selectStickerList": "draftJsStickerPlugin__selectStickerList__3F4Za"
};

var _selectStyles2 = _interopRequireDefault(_selectStyles);

var _selectStickerStyles = {
  "selectSticker": "draftJsStickerPlugin__selectSticker__3VCSX",
  "root": "draftJsStickerPlugin__root__32LE-",
  "selectStickerImage": "draftJsStickerPlugin__selectStickerImage__HoOE2"
};

var _selectStickerStyles2 = _interopRequireDefault(_selectStickerStyles);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var defaultTheme = {
  sticker: _stickerStyles2.default.sticker,
  stickerImage: _stickerStyles2.default.stickerImage,
  stickerRemoveButton: _stickerStyles2.default.stickerRemoveButton,

  select: _selectStyles2.default.select,
  selectPopover: _selectStyles2.default.selectPopover,
  selectClosedPopover: _selectStyles2.default.selectClosedPopover,
  selectBottomGradient: _selectStyles2.default.selectBottomGradient,
  selectButton: _selectStyles2.default.selectButton,
  selectPressedButton: _selectStyles2.default.selectPressedButton,
  selectStickerList: _selectStyles2.default.selectStickerList,

  selectSticker: _selectStickerStyles2.default.selectSticker,
  selectStickerImage: _selectStickerStyles2.default.selectStickerImage
};

var stickerPlugin = function stickerPlugin() {
  var config = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

  // Styles are overwritten instead of merged as merging causes a lot of confusion.
  //
  // Why? Because when merging a developer needs to know all of the underlying
  // styles which needs a deep dive into the code. Merging also makes it prone to
  // errors when upgrading as basically every styling change would become a major
  // breaking change. 1px of an increased padding can break a whole layout.
  var theme = config.theme ? config.theme : defaultTheme;
  var stickers = config.stickers;
  var selectButtonContent = config.selectButtonContent ? config.selectButtonContent : '☺';

  // default to true if not explicitly set to false
  var attachRemoveButton = config.attachRemoveButton !== false;
  var stickerSelectProps = {
    selectButtonContent: selectButtonContent,
    stickers: stickers,
    theme: theme
  };
  var stickerProps = {
    attachRemoveButton: attachRemoveButton,
    stickers: stickers,
    theme: theme
  };
  var blockRendererConfig = _extends({}, config, {
    Sticker: (0, _decorateComponentWithProps2.default)(_Sticker2.default, stickerProps)
  });
  return {
    blockRendererFn: (0, _blockRendererFn2.default)(blockRendererConfig),
    onChange: _cleanupEmptyStickers2.default,
    add: _addSticker2.default,
    remove: _removeSticker2.default,
    StickerSelect: (0, _decorateComponentWithProps2.default)(_StickerSelect2.default, stickerSelectProps)
  };
};

exports.default = stickerPlugin;