'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _draftJs = require('draft-js');

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

exports.default = function (PluginEditor) {
  return function (_Component) {
    _inherits(NestedEditor, _Component);

    function NestedEditor(props) {
      _classCallCheck(this, NestedEditor);

      var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(NestedEditor).call(this, props));

      _this.onChange = function (editorState) {
        var readOnly = _this.props.readOnly;

        if (readOnly) return;
        _this.setState({ editorState: editorState });
        _this.props.onChange((0, _draftJs.convertToRaw)(editorState.getCurrentContent()));
      };

      _this.mouseDown = function (event) {
        var _this$props = _this.props;
        var readOnly = _this$props.readOnly;
        var setFocus = _this$props.setFocus;

        event.stopPropagation();
        if (readOnly === false) {
          return;
        }

        setFocus();
      };

      _this.stopPropagation = function (event) {
        if (event.keyCode === 38) {
          event.stopPropagation();
        } else if (event.keyCode === 40) {
          event.stopPropagation();
        } else if (event.keyCode === 8) {
          event.stopPropagation();
        }
      };

      _this.state = {
        editorState: props.editorState ? _draftJs.EditorState.createWithContent((0, _draftJs.convertFromRaw)(props.editorState)) : _draftJs.EditorState.createWithContent(_draftJs.ContentState.createFromText('Insert text ...'))
      };
      return _this;
    }

    _createClass(NestedEditor, [{
      key: 'componentDidMount',
      value: function componentDidMount() {
        this.DOMNode = _reactDom2.default.findDOMNode(this.refs.editor);
        this.DOMNode.addEventListener('mousedown', this.mouseDown, false);
        this.DOMNode.addEventListener('keydown', this.stopPropagation, false);
      }
    }, {
      key: 'componentWillUnmount',
      value: function componentWillUnmount() {
        this.DOMNode.removeEventListener('mousedown', this.listener, false);
        this.DOMNode.removeEventListener('keydown', this.stopPropagation, false);
      }
    }, {
      key: 'render',
      value: function render() {
        var editorState = this.state.editorState;
        var readOnly = this.props.readOnly;


        return _react2.default.createElement(PluginEditor, _extends({}, this.props, { ref: 'editor', editorState: editorState, onChange: this.onChange, readOnly: readOnly }));
      }
    }]);

    return NestedEditor;
  }(_react.Component);
};