'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TableComponent = function TableComponent(_ref) {
  var theme = _ref.theme;
  return function (_Component) {
    _inherits(Table, _Component);

    function Table(props) {
      _classCallCheck(this, Table);

      var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Table).call(this));

      _this.setFocus = function (row, column) {
        var setFocus = _this.props.setFocus;

        setFocus();
        _this.setState({ focusedEdit: { row: row, column: column } });
      };

      _this.addRow = function () {
        var setEntityData = _this.props.blockProps.setEntityData;
        var rows = _this.state.rows;

        var newRows = [].concat(_toConsumableArray(rows), [[]]);
        setEntityData({ rows: newRows });
        _this.setState({ rows: newRows });
      };

      _this.addColumn = function () {
        var setEntityData = _this.props.blockProps.setEntityData;
        var numberOfColumns = _this.state.numberOfColumns;

        var newNumberOfColumns = (numberOfColumns || 1) + 1;
        setEntityData({ numberOfColumns: newNumberOfColumns });
        _this.setState({ numberOfColumns: newNumberOfColumns });
      };

      _this.updateEntityData = function (editorState, row, column) {
        var setEntityData = _this.props.blockProps.setEntityData;
        var _this$state = _this.state;
        var rows = _this$state.rows;
        var numberOfColumns = _this$state.numberOfColumns;

        var newRows = rows || [{}];
        while (newRows[row].length < (numberOfColumns || 1)) {
          newRows[row].push(null);
        }
        newRows[row][column] = editorState;
        setEntityData({ rows: newRows });
        _this.setState({ rows: newRows });
      };

      _this.state = {
        rows: props.blockProps.entityData.rows || [[]],
        numberOfColumns: props.blockProps.entityData.numberOfColumns || 1,
        focusedEdit: null
      };
      return _this;
    }

    _createClass(Table, [{
      key: 'componentDidMount',
      value: function componentDidMount() {
        var _this2 = this;

        var addActions = this.props.addActions;

        if (addActions) {
          addActions([{
            button: _react2.default.createElement(
              'span',
              null,
              '+ Row'
            ),
            label: 'Add a row',
            active: false,
            toggle: function toggle() {
              return _this2.addRow();
            }
          }, {
            button: _react2.default.createElement(
              'span',
              null,
              '+ Column'
            ),
            label: 'Add a column',
            active: false,
            toggle: function toggle() {
              return _this2.addColumn();
            }
          }]);
        }
      }
    }, {
      key: 'render',
      value: function render() {
        var _this3 = this;

        var _state = this.state;
        var rows = _state.rows;
        var numberOfColumns = _state.numberOfColumns;
        var focusedEdit = _state.focusedEdit;
        var _props = this.props;
        var style = _props.style;
        var className = _props.className;
        var blockProps = _props.blockProps;
        var isFocused = blockProps.isFocused;
        var renderNestedEditor = blockProps.renderNestedEditor;


        var classNames = [className, theme.table].filter(function (p) {
          return p;
        });

        return _react2.default.createElement(
          'table',
          { className: classNames.join(' '), cellSpacing: '0', style: style },
          _react2.default.createElement(
            'tbody',
            null,
            rows.map(function (row, rowI) {
              return _react2.default.createElement(
                'tr',
                { key: rowI },
                Array.from(new Array(numberOfColumns), function (x, i) {
                  return i;
                }).map(function (column, columnI) {
                  return _react2.default.createElement(
                    'td',
                    { key: columnI },
                    renderNestedEditor({
                      block: _this3,
                      editorState: row[columnI],
                      onChange: function onChange(editorState) {
                        return _this3.updateEntityData(editorState, rowI, columnI);
                      },
                      setFocus: function setFocus() {
                        return _this3.setFocus(rowI, columnI);
                      },
                      active: isFocused && focusedEdit && focusedEdit.row === rowI && focusedEdit.column === columnI
                    })
                  );
                })
              );
            })
          )
        );
      }
    }]);

    return Table;
  }(_react.Component);
};

exports.default = TableComponent;