'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tableStyles = exports.tableCreator = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _table = require('./components/table');

var _table2 = _interopRequireDefault(_table);

var _nestedEditor = require('./components/nested-editor');

var _nestedEditor2 = _interopRequireDefault(_nestedEditor);

var _style = {
  "table": "draftJsEmojiPlugin__table__39DpF",
  "even": "draftJsEmojiPlugin__even__Hc165"
};

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var defaultTheme = _extends({}, _style2.default);

var createRenderer = function createRenderer(Editor) {
  var NestedEditor = (0, _nestedEditor2.default)(Editor);
  return function (_ref) {
    var block = _ref.block;
    var editorState = _ref.editorState;
    var onChange = _ref.onChange;
    var setFocus = _ref.setFocus;
    var active = _ref.active;
    var pluginEditor = block.props.blockProps.pluginEditor;

    return _react2.default.createElement(NestedEditor, _extends({}, pluginEditor.props, { setFocus: setFocus, setReadOnly: pluginEditor.setReadOnly, readOnly: !active, editorState: editorState, onChange: onChange }));
  };
};

var tablePlugin = function tablePlugin(config) {
  var type = config.type || 'block-table';
  var theme = config.theme ? config.theme : defaultTheme;
  var Editor = config.Editor;
  var renderNestedEditor = createRenderer(Editor);

  var component = config.component || (0, _table2.default)({ theme: theme });

  return {
    // Handle 'block-image' block-type with Image component
    blockRendererFn: function blockRendererFn(contentBlock) {
      var blockType = contentBlock.getType();
      if (blockType === type) {
        return {
          component: component,
          props: {
            renderNestedEditor: renderNestedEditor
          }
        };
      }return {
        props: {
          renderNestedEditor: renderNestedEditor
        }
      };
    }
  };
};

exports.default = tablePlugin;
var tableCreator = exports.tableCreator = _table2.default;
var tableStyles = exports.tableStyles = _style2.default;