/**
 * Copyright (c) 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule DraftDecoratorType
 * 
 */

/**
 * An interface for document decorator classes, allowing the creation of
 * custom decorator classes.
 *
 * See `CompositeDraftDecorator` for the most common use case.
 */
'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

/**
 * Given a `ContentBlock`, return an immutable List of decorator keys.
 */

/**
 * Given a decorator key, return the component to use when rendering
 * this decorated range.
 */

/**
 * Given a decorator key, optionally return the props to use when rendering
 * this decorated range.
 */