## Submitting issues

### Reduced test case required

All bug reports and problem issues require a [**reduced test case**](https://css-tricks.com/reduced-test-cases/). Create one by forking any one of the [CodePen demos](https://codepen.io/desandro/pens/tags/?grid_type=list&selected_tag=draggabilly-docs&sort_order=asc) from [the docs](https://draggabilly.desandro.com). Try forking these CodePens:

**CodePens**

+ [basic jQuery demo](https://codepen.io/desandro/pen/yyRapr)
+ [basic vanilla JS demo](https://codepen.io/desandro/pen/EadgXx)

**Test cases**

+ A reduced test case clearly demonstrates the bug or issue.
+ It contains the bare minimum HTML, CSS, and JavaScript required to demonstrate the bug.
+ A link to your production site is **not** a reduced test case.

Providing a reduced test case is the best way to get your issue addressed. They help you point out the problem. They help me verify and debug the problem. They help others understand the problem. Without a reduced test case, your issue may be closed.

## Pull requests

_Contributions are appreciated!_

+ _Typos and one-line fixes:_ send them right in.
+ _Larger changes_ like new features: **ask first** by opening a new issue. I can be particular about my vision for Draggabilly. I do not want you to spend effort on code that I may not wish to merge.
+ **Follow the code style.** 2-space indentation, spaces in brackets, semicolons, trailing commas.
+ **Do not run `gulp` and update `dist/` files.** I'll take care of this after merging.
