// Generated by dts-bundle-generator v8.1.2

export type StageDefinition = {
	x: number;
	y: number;
	width: number;
	height: number;
};
export type State = {
	isInitialized?: boolean;
	activeIndex?: number;
	activeElement?: Element;
	activeStep?: DriveStep;
	previousElement?: Element;
	previousStep?: DriveStep;
	popover?: PopoverDOM;
	__previousElement?: Element;
	__activeElement?: Element;
	__previousStep?: DriveStep;
	__activeStep?: DriveStep;
	__activeOnDestroyed?: Element;
	__resizeTimeout?: number;
	__transitionCallback?: () => void;
	__activeStagePosition?: StageDefinition;
	__overlaySvg?: SVGSVGElement;
};
export type DriverHook = (element: Element | undefined, step: DriveStep, opts: {
	config: Config;
	state: State;
	driver: Driver;
}) => void;
export type Config = {
	steps?: DriveStep[];
	animate?: boolean;
	overlayColor?: string;
	overlayOpacity?: number;
	smoothScroll?: boolean;
	allowClose?: boolean;
	overlayClickBehavior?: "close" | "nextStep";
	stagePadding?: number;
	stageRadius?: number;
	disableActiveInteraction?: boolean;
	allowKeyboardControl?: boolean;
	popoverClass?: string;
	popoverOffset?: number;
	showButtons?: AllowedButtons[];
	disableButtons?: AllowedButtons[];
	showProgress?: boolean;
	progressText?: string;
	nextBtnText?: string;
	prevBtnText?: string;
	doneBtnText?: string;
	onPopoverRender?: (popover: PopoverDOM, opts: {
		config: Config;
		state: State;
		driver: Driver;
	}) => void;
	onHighlightStarted?: DriverHook;
	onHighlighted?: DriverHook;
	onDeselected?: DriverHook;
	onDestroyStarted?: DriverHook;
	onDestroyed?: DriverHook;
	onNextClick?: DriverHook;
	onPrevClick?: DriverHook;
	onCloseClick?: DriverHook;
};
export type Side = "top" | "right" | "bottom" | "left" | "over";
export type Alignment = "start" | "center" | "end";
export type AllowedButtons = "next" | "previous" | "close";
export type Popover = {
	title?: string;
	description?: string;
	side?: Side;
	align?: Alignment;
	showButtons?: AllowedButtons[];
	showProgress?: boolean;
	disableButtons?: AllowedButtons[];
	popoverClass?: string;
	progressText?: string;
	doneBtnText?: string;
	nextBtnText?: string;
	prevBtnText?: string;
	onPopoverRender?: (popover: PopoverDOM, opts: {
		config: Config;
		state: State;
		driver: Driver;
	}) => void;
	onNextClick?: DriverHook;
	onPrevClick?: DriverHook;
	onCloseClick?: DriverHook;
};
export type PopoverDOM = {
	wrapper: HTMLElement;
	arrow: HTMLElement;
	title: HTMLElement;
	description: HTMLElement;
	footer: HTMLElement;
	progress: HTMLElement;
	previousButton: HTMLButtonElement;
	nextButton: HTMLButtonElement;
	closeButton: HTMLButtonElement;
	footerButtons: HTMLElement;
};
export type DriveStep = {
	element?: string | Element | (() => Element);
	onHighlightStarted?: DriverHook;
	onHighlighted?: DriverHook;
	onDeselected?: DriverHook;
	popover?: Popover;
	disableActiveInteraction?: boolean;
};
export interface Driver {
	isActive: () => boolean;
	refresh: () => void;
	drive: (stepIndex?: number) => void;
	setConfig: (config: Config) => void;
	setSteps: (steps: DriveStep[]) => void;
	getConfig: () => Config;
	getState: (key?: string) => any;
	getActiveIndex: () => number | undefined;
	isFirstStep: () => boolean;
	isLastStep: () => boolean;
	getActiveStep: () => DriveStep | undefined;
	getActiveElement: () => Element | undefined;
	getPreviousElement: () => Element | undefined;
	getPreviousStep: () => DriveStep | undefined;
	moveNext: () => void;
	movePrevious: () => void;
	moveTo: (index: number) => void;
	hasNextStep: () => boolean;
	hasPreviousStep: () => boolean;
	highlight: (step: DriveStep) => void;
	destroy: () => void;
}
export declare function driver(options?: Config): Driver;

export {};
