'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

exports['default'] = {
  /**
   * Returns a new string where the first character is capitalized.
   *
   * @param  {String} string
   * @return {String}
   */
  capitalizeFirstLetter: function capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
  },

  /**
   * Serializes an error.
   * 
   * @param  {Error} err
   * 
   * @return {Object} The serialized error
   */
  serializeError: function serializeError(err) {
    var serialized = {};
    Object.getOwnPropertyNames(err).forEach(function (key) {
      return serialized[key] = err[key];
    });
    return serialized;
  },

  /**
   * Unserializes an error.
   * 
   * @param  {Object} obj The serialized error
   * 
   * @return {Error} The unserialized error
   */
  unserializeError: function unserializeError(obj) {
    var err = new Error(obj.message);

    _lodash2['default'].each(obj, function (value, key) {
      if (obj.hasOwnProperty(key) && key !== 'message') {
        err[key] = value;
      }
    });

    return err;
  }
};
module.exports = exports['default'];