'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _helpers = require('./helpers');

var _helpers2 = _interopRequireDefault(_helpers);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

/**
 * Base class for other serializers
 *
 * @class Serializer
 */

var Serializer = (function () {
  function Serializer() {
    _classCallCheck(this, Serializer);
  }

  _createClass(Serializer, [{
    key: 'serializeItem',

    /**
     * Serialize an item.
     *
     * @protected
     * @param  {Object} blueprint
     * @param  {Object} item
     * @return {Object} The serialized item
     */
    value: function serializeItem(blueprint, item) {
      var _this = this;

      item = _lodash2['default'].clone(item);
      var column;
      var columns = blueprint.columns;

      Object.keys(item).forEach(function (key) {
        if (columns[key]) {
          column = columns[key];

          // if the given value is null, use default value when present
          if ((item[key] === null || item[key] === undefined) && column.hasOwnProperty('default')) {
            item[key] = column['default'];
          }

          if (item[key] === null || item[key] === undefined) {
            return null;
          }

          var method = 'serialize' + _helpers2['default'].capitalizeFirstLetter(column.type).replace('[]', 'Array');
          if (_this[method]) {
            item[key] = _this[method](item[key]);
          }
        }
      });

      return this.sortKeys(item);
    }
  }, {
    key: 'serializeString',

    /**
     * Serialize a string.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeString(value) {
      if (value === '') {
        return null;
      }
      return value;
    }
  }, {
    key: 'serializeStringArray',

    /**
     * Serialize a string array.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeStringArray(value) {
      return _lodash2['default'].map(value, this.serializeString);
    }
  }, {
    key: 'serializeText',

    /**
     * Serialize a text.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeText(value) {
      if (value === '') {
        return null;
      }
      return value;
    }
  }, {
    key: 'serializeTextArray',

    /**
     * Serialize a text array.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeTextArray(value) {
      return _lodash2['default'].map(value, this.serializeText);
    }
  }, {
    key: 'serializeUuid',

    /**
     * Serialize a string.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeUuid(value) {
      if (value === '') {
        return null;
      }
      return value;
    }
  }, {
    key: 'serializeUuidArray',

    /**
     * Serialize a string.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeUuidArray(value) {
      return _lodash2['default'].map(value, this.serializeUuid);
    }
  }, {
    key: 'serializeInteger',

    /**
     * Serialize an integer.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeInteger(value) {
      return value;
    }
  }, {
    key: 'serializeIntegerArray',

    /**
     * Serialize an integer array.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeIntegerArray(value) {
      return _lodash2['default'].map(value, this.serializeInteger, this);
    }
  }, {
    key: 'serializeFloat',

    /**
     * Serialize a float.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeFloat(value) {
      return value;
    }
  }, {
    key: 'serializeFloatArray',

    /**
     * Serialize an float array.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeFloatArray(value) {
      return _lodash2['default'].map(value, this.serializeFloat, this);
    }
  }, {
    key: 'dateStringToMoment',

    /**
     * Convert a date string to a date object.
     *
     * @protected
     * @param  {string} value
     */
    value: function dateStringToMoment(value) {
      return (0, _moment2['default'])(new Date(value));
    }
  }, {
    key: 'serializeDatetime',

    /**
     * Serialize a datetime string to a datetime.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeDatetime(value) {
      return this.dateStringToMoment(value).format('YYYY-MM-DD HH:mm:ss');
    }
  }, {
    key: 'serializeDatetimeArray',

    /**
     * Serialize a datetime array string to a datetime.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeDatetimeArray(value) {
      return _lodash2['default'].map(value, this.serializeDatetime, this);
    }
  }, {
    key: 'serializeDate',

    /**
     * Serialize a date string to a date.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeDate(value) {
      return this.dateStringToMoment(value).format('YYYY-MM-DD');
    }
  }, {
    key: 'serializeDateArray',

    /**
     * Serialize a date array string to a array of dates.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeDateArray(value) {
      return _lodash2['default'].map(value, this.serializeDate, this);
    }
  }, {
    key: 'serializeBoolean',

    /**
     * Serialize to boolean.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeBoolean(value) {
      return !!value;
    }
  }, {
    key: 'serializeBooleanArray',

    /**
     * Serialize to boolean array.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeBooleanArray(value) {
      return _lodash2['default'].map(value, this.serializeBoolean, this);
    }
  }, {
    key: 'serializeJson',

    /**
     * Serialize to json.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeJson(value) {
      return value;
    }
  }, {
    key: 'serializeJsonArray',

    /**
     * Serialize to array of json.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeJsonArray(value) {
      return _lodash2['default'].map(value, this.serializeJson, this);
    }
  }, {
    key: 'serializePoint',

    /**
     * Serialize a point.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializePoint(value) {
      return this.serializeJson(value);
    }
  }, {
    key: 'serializePointArray',

    /**
     * Serialize a point array.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializePointArray(value) {
      return this.serializeJson(value);
    }
  }, {
    key: 'serializeLinestring',

    /**
     * Serialize a linestring.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeLinestring(value) {
      return this.serializeJson(value);
    }
  }, {
    key: 'serializeLinestringArray',

    /**
     * Serialize a linestring array.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializeLinestringArray(value) {
      return this.serializeJson(value);
    }
  }, {
    key: 'serializePolygon',

    /**
     * Serialize a polygon.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializePolygon(value) {
      return this.serializeJson(value);
    }
  }, {
    key: 'serializePolygonArray',

    /**
     * Serialize a polygon array.
     *
     * @protected
     * @param  {string} value
     */
    value: function serializePolygonArray(value) {
      return this.serializeJson(value);
    }
  }, {
    key: 'sortKeys',

    /**
     * Sort keys of an object.
     *
     * @protected
     * @param  {Object} item
     */
    value: function sortKeys(item) {
      var value,
          sortedItem = {},
          keys = _lodash2['default'].keys(item),
          sortedKeys = _lodash2['default'].sortBy(keys, function (key) {
        return key;
      });

      _lodash2['default'].each(sortedKeys, function (key) {
        value = item[key];
        sortedItem[key] = value;
      });

      return sortedItem;
    }
  }]);

  return Serializer;
})();

exports['default'] = Serializer;
module.exports = exports['default'];