'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

/**
 * Transformer
 * 
 * @class Transformer
 */

var Transformer = (function () {
  function Transformer() {
    _classCallCheck(this, Transformer);
  }

  _createClass(Transformer, [{
    key: 'transform',
    value: function transform(changes, blueprintId, item, fromProjectVersion, toProjectVersion) {
      var clonedItem = _lodash2['default'].clone(item);
      var filteredChanges = this.filterChangesBetween(changes, fromProjectVersion, toProjectVersion);
      return this.applyChanges(filteredChanges, blueprintId, clonedItem);
    }
  }, {
    key: 'applyChanges',
    value: function applyChanges(changes, blueprintId, item) {
      _lodash2['default'].each(changes, function (change) {
        if (change.blueprint !== blueprintId) {
          return;
        }

        switch (change.type) {
          case 'blueprint.remove':
            item = null;
            break;
          case 'column.create':
            item[change.column] = null;
            break;
          case 'column.rename':
            item[change.value] = item[change.column] === undefined ? null : item[change.column];
            delete item[change.column];
            break;
          case 'column.update':
            if (change.key === 'type') {
              item[change.column] = null;
            }
            break;
          case 'column.remove':
            delete item[change.column];
            break;
        }
      });

      return item;
    }
  }, {
    key: 'filterChangesBetween',
    value: function filterChangesBetween(changes, fromVersion, toVersion) {
      if (toVersion === undefined) {
        toVersion = Number.POSITIVE_INFINITY;
      }

      if (fromVersion === toVersion) {
        return [];
      }

      var lastVersion = 0;
      var filteredChanges = _lodash2['default'].filter(changes, function (change) {
        if (change.type === 'project.tag') {
          lastVersion = change.value;
        }
        return lastVersion >= fromVersion && lastVersion <= toVersion || lastVersion >= toVersion && lastVersion <= fromVersion;
      });

      if (fromVersion > toVersion) {
        return this.invertChanges(filteredChanges);
      }
      return filteredChanges;
    }
  }, {
    key: 'invertChanges',
    value: function invertChanges(changes) {
      changes = changes.reverse();
      return _lodash2['default'].filter(_lodash2['default'].map(changes, this.invertChange), function (change) {
        return change !== undefined;
      });
    }
  }, {
    key: 'invertChange',
    value: function invertChange(change) {
      switch (change.type) {
        case 'project.tag':
          return change;
        case 'blueprint.create':
          return {
            type: 'blueprint.remove',
            blueprint: change.blueprint
          };
        case 'blueprint.update':
          return {
            type: 'blueprint.update',
            blueprint: change.blueprint,
            key: change.key,
            value: change.oldValue,
            oldValue: change.value
          };
        case 'blueprint.remove':
          return {
            type: 'blueprint.create',
            blueprint: change.blueprint,
            value: change.oldValue
          };
        case 'column.create':
          return {
            type: 'column.remove',
            blueprint: change.blueprint,
            column: change.column
          };
        case 'column.rename':
          return {
            type: 'column.rename',
            blueprint: change.blueprint,
            column: change.value,
            value: change.column
          };
        case 'column.update':
          return {
            type: 'column.update',
            blueprint: change.blueprint,
            column: change.column,
            key: change.key,
            oldValue: change.value,
            value: change.oldValue
          };
        case 'column.remove':
          return {
            type: 'column.create',
            blueprint: change.blueprint,
            column: change.column,
            value: change.oldValue
          };
      }
    }
  }]);

  return Transformer;
})();

exports['default'] = Transformer;
module.exports = exports['default'];