import _ from 'lodash';

export default {
  /**
   * Returns a new string where the first character is capitalized.
   *
   * @param  {String} string
   * @return {String}
   */
  capitalizeFirstLetter: (string) => {
    return string.charAt(0).toUpperCase() + string.slice(1);
  },

  /**
   * Serializes an error.
   * 
   * @param  {Error} err
   * 
   * @return {Object} The serialized error
   */
  serializeError: (err) => {
    var serialized = {};
    Object.getOwnPropertyNames(err)
      .forEach((key) => serialized[key] = err[key]);
    return serialized;
  },

  /**
   * Unserializes an error.
   * 
   * @param  {Object} obj The serialized error
   * 
   * @return {Error} The unserialized error
   */
  unserializeError: (obj) => {
    var err = new Error(obj.message);

    _.each(obj, (value, key) => {
      if (obj.hasOwnProperty(key) && key !== 'message') {
        err[key] = value;
      }
    });

    return err;
  }
}
