#!/bin/bash

THIS_DIR=$(dirname "$0")

clean() {
  echo "dstore-helpers: Cleaning lib directory"
  rm -rf $THIS_DIR/../lib/
}

compile() {
  echo "dstore-helpers: Compiling all files..."
  ./node_modules/.bin/babel --debug --stage 0 $THIS_DIR/../src -d $THIS_DIR/../lib
}

watch() {
  echo "dstore-helpers: Watch for changes..."
  ./node_modules/.bin/babel --debug --watch --stage 0 $THIS_DIR/../src -d $THIS_DIR/../lib
}

if [[ $@ == *"watch"* ]]
then
  watch
fi

if [[ $@ == *"clean"* ]]
then
  clean
fi

if [[ $@ == *"compile"* ]]
then
  compile
fi

if [[ $@ == *"all"* ]]
then
  clean
  compile
  watch
fi
