'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _levelParty = require('level-party');

var _levelParty2 = _interopRequireDefault(_levelParty);

var _levelSublevel = require('level-sublevel');

var _levelSublevel2 = _interopRequireDefault(_levelSublevel);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _mkdirp = require('mkdirp');

var _mkdirp2 = _interopRequireDefault(_mkdirp);

/**
 * LeveldbAdapter
 * 
 * @class LeveldbAdapter
 */

var LeveldbAdapter = (function () {

  /**
   * constructor
   * 
   * @param {String} path
   */

  function LeveldbAdapter(path) {
    _classCallCheck(this, LeveldbAdapter);

    this.path = path;
    this.connections = {};
    (0, _mkdirp2['default'])(this.path);
  }

  _createClass(LeveldbAdapter, [{
    key: 'getClient',

    /**
     * Get the level client.
     *
     * @param  {String} projectId
     * @param  {Number} projectVersion
     *
     * @return {LeveldbClient}
     */
    value: function getClient(projectId, projectVersion) {
      if (!this.connections[projectId + projectVersion]) {
        this.connections[projectId + projectVersion] = (0, _levelSublevel2['default'])((0, _levelParty2['default'])(this.path + '/' + projectId + 'v' + projectVersion));
      }
      return this.connections[projectId + projectVersion];
    }
  }, {
    key: 'closeConnections',

    /**
     * Closes all connections
     */
    value: function closeConnections() {
      var _this = this;

      Object.keys(this.connections).forEach(function (connectionKey) {
        _this.connections[connectionKey].close();
      });
    }
  }]);

  return LeveldbAdapter;
})();

exports['default'] = LeveldbAdapter;
module.exports = exports['default'];