'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var rmRF = _bluebird2['default'].promisify(require('rimraf'));

/**
 * LeveldbDropper
 * 
 * @class LeveldbDropper
 * 
 * @param {String} path
 */

var LeveldbDropper = (function () {
  function LeveldbDropper(path) {
    _classCallCheck(this, LeveldbDropper);

    this.path = path;
  }

  _createClass(LeveldbDropper, [{
    key: 'drop',

    /**
     * Create / migrate database.
     *
     * @param  {String} projectId
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function drop(projectId, projectVersion) {
      var db = projectId + 'v' + projectVersion;
      return rmRF(this.path + '/' + db)['catch'](function () {});
    }
  }]);

  return LeveldbDropper;
})();

exports['default'] = LeveldbDropper;
module.exports = exports['default'];

// db doesn't exist
// noop