'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

/**
 * LeveldbFacade
 * 
 * @class LeveldbFacade
 *
 */

var LeveldbFacade = (function () {

  /**
   * @param {Repository} repository
   * @param {Dropper}    dropper
   * @param {Syncer}     syncer
   */

  function LeveldbFacade(repository, dropper, syncer) {
    _classCallCheck(this, LeveldbFacade);

    this.repository = repository;
    this.dropper = dropper;
    this.syncer = syncer;
  }

  _createClass(LeveldbFacade, [{
    key: 'get',

    /**
     * Retrieve item
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {String} id
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function get(projectId, blueprint, id, projectVersion) {
      return this.repository.get(projectId, blueprint, id, projectVersion);
    }
  }, {
    key: 'getAll',

    /**
     * Retrieve all items
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function getAll(projectId, blueprint, projectVersion) {
      return this.repository.getAll(projectId, blueprint, projectVersion);
    }
  }, {
    key: 'put',

    /**
     * Insert / update item.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {String} id
     * @param  {Object} item
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function put(projectId, blueprint, id, item, projectVersion) {
      return this.repository.put(projectId, blueprint, id, item, projectVersion);
    }
  }, {
    key: 'putMany',

    /**
     * Batch insert / update items.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Object} items
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function putMany(projectId, blueprint, items, projectVersion) {
      return this.repository.putMany(projectId, blueprint, items, projectVersion);
    }
  }, {
    key: 'del',

    /**
     * Delete item.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Object} id
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function del(projectId, blueprint, id, projectVersion) {
      return this.repository.del(projectId, blueprint, id, projectVersion);
    }
  }, {
    key: 'sync',

    /**
     * Sync data from the old leveldb to the new one,
     * transforming items to the new version along the way when needed.
     *
     * @param  {String} projectId
     * @param  {Number} toProjectVersion
     * @param  {Object} fromBlueprints
     * @param  {Object} toBlueprints
     * @param  {Object} log
     *
     * @return {BBPromise}
     */
    value: function sync(projectId, toProjectVersion, fromBlueprints, toBlueprints, log) {
      return this.syncer.sync(projectId, toProjectVersion, fromBlueprints, toBlueprints, log);
    }
  }, {
    key: 'migrate',

    /**
     * Create a new leveldb database.
     *
     * @param  {String} projectId
     * @param  {Number} projectVersion
     * @param  {Object} blueprints
     *
     * @return {BBPromise}
     */
    value: function migrate(projectId, projectVersion, blueprints) {
      return _bluebird2['default'].resolve();
    }
  }, {
    key: 'drop',

    /**
     * Drop leveldb database.
     *
     * @param  {String} projectId
     * @param  {Number} projectVersion
     * 
     * @return {BBPromise}
     */
    value: function drop(projectId, projectVersion) {
      return this.dropper.drop(projectId, projectVersion);
    }
  }, {
    key: 'serialize',

    /**
     * Serialize an item to make it compatible with leveldb.
     *
     * @param  {Object} blueprint
     * @param  {Object} item
     * 
     * @return {Object} The serialized item
     */
    value: function serialize(blueprint, item) {
      return this.serializer.serializer(blueprint, item);
    }
  }]);

  return LeveldbFacade;
})();

exports['default'] = LeveldbFacade;
module.exports = exports['default'];