'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _dstoreHelpers = require('dstore-helpers');

/**
 * LeveldbMigrator
 * 
 * @class LeveldbMigrator
 */

var LeveldbMigrator = (function () {
  /**
   * @param {Client} client
   */

  function LeveldbMigrator(client) {
    _classCallCheck(this, LeveldbMigrator);

    this.client = client;
  }

  _createClass(LeveldbMigrator, [{
    key: 'migrate',

    /**
     * Create a new elasticsearch index and put the mapping.
     *
     * @param  {String} projectId
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function migrate(projectId, projectVersion, blueprints) {
      var _this = this;

      var opts = {
        index: projectId + 'v' + projectVersion,
        projectVersion: projectVersion,
        projectId: projectId,
        blueprints: blueprints
      };

      return this.createIndex(opts).then(function () {
        return _this.putMapping(opts);
      }).then(function () {
        return _this.updateAlias(opts);
      });
    }
  }, {
    key: 'createIndex',

    /**
     * Create a new elasticsearch index.
     *
     * @protected
     * @param opts
     * @param opts.index The name of the index to create
     *
     * @return {BBPromise}
     */
    value: function createIndex(opts) {
      var _this2 = this;

      return this.client.indices.exists({
        index: opts.index
      }).then(function (exists) {
        if (!exists) {
          return _this2.client.indices.create({
            index: opts.index
          });
        }
      });
    }
  }, {
    key: 'putMapping',

    /**
     * Create and put a mapping.
     *
     * @protected
     * @param opts
     * @param opts.blueprints  The blueprints to turn into a mapping
     * @param opts.index       The index to put the mapping to
     *
     * @return {BBPromise.<undefined>}
     */
    value: function putMapping(opts) {
      var _this3 = this;

      return _bluebird2['default'].map(_lodash2['default'].values(opts.blueprints), function (blueprint) {
        var mapping = {};

        var properties = _lodash2['default'].object(_lodash2['default'].map(blueprint.columns, function (column, columnKey) {
          var property = _this3['define' + _dstoreHelpers.helpers.capitalizeFirstLetter(column.type).replace('[]', '')](column);

          // if extra options are given for elasticsearch, use those instead
          if (column.elasticsearch) {
            property = column.elasticsearch;
          }

          return [columnKey, property];
        }));

        mapping[blueprint.elasticsearch.type] = {
          _id: { path: 'id' },
          properties: properties
        };

        return _this3.client.indices.putMapping({
          index: opts.index,
          type: blueprint.elasticsearch.type,
          body: mapping
        });
      });
    }
  }, {
    key: 'updateAlias',
    value: function updateAlias(opts) {
      var _this4 = this;

      return _bluebird2['default'].resolve().then(function () {
        if (opts.projectVersion > 1) {
          return _this4.client.indices.deleteAlias({
            index: opts.projectId + 'v' + (opts.projectVersion - 1),
            name: opts.projectId
          });
        }
      }).then(function () {
        return _this4.client.indices.putAlias({
          index: opts.index,
          name: opts.projectId
        });
      });
    }
  }, {
    key: 'defineUuid',

    /**
     * Define a uuid mapping.
     *
     * @protected
     */
    value: function defineUuid() {
      return this.defineString();
    }
  }, {
    key: 'defineText',

    /**
     * Define a text mapping.
     *
     * @protected
     */
    value: function defineText() {
      return this.defineString();
    }
  }, {
    key: 'defineString',

    /**
     * Define a string mapping.
     *
     * @protected
     */
    value: function defineString() {
      return {
        type: 'string'
      };
    }
  }, {
    key: 'definePoint',

    /**
     * Define a point mapping.
     *
     * @protected
     */
    value: function definePoint() {
      return {
        type: 'geo_point'
      };
    }
  }, {
    key: 'defineLinestring',

    /**
     * Define a linestring mapping.
     *
     * @protected
     */
    value: function defineLinestring() {
      return this.defineShape();
    }
  }, {
    key: 'definePolygon',

    /**
     * Define a polygon mapping.
     *
     * @protected
     */
    value: function definePolygon() {
      return this.defineShape();
    }
  }, {
    key: 'defineShape',

    /**
     * Define a shape mapping.
     *
     * @protected
     */
    value: function defineShape() {
      return {
        type: 'geo_shape',
        tree: 'quadtree',
        precision: '10m'
      };
    }
  }, {
    key: 'defineDate',

    /**
     * Define a date mapping.
     *
     * @protected
     */
    value: function defineDate() {
      return {
        type: 'date',
        format: 'yyyy-MM-dd'
      };
    }
  }, {
    key: 'defineDatetime',

    /**
     * Define a datetime mapping.
     *
     * @protected
     */
    value: function defineDatetime() {
      return {
        type: 'date',
        format: 'yyyy-MM-dd HH:mm:ss'
      };
    }
  }, {
    key: 'defineFloat',

    /**
     * Define a float mapping.
     *
     * @protected
     */
    value: function defineFloat() {
      return {
        type: 'float'
      };
    }
  }, {
    key: 'defineInteger',

    /**
     * Define a integer mapping.
     *
     * @protected
     */
    value: function defineInteger() {
      return {
        type: 'integer'
      };
    }
  }, {
    key: 'defineBoolean',

    /**
     * Define a boolean mapping.
     *
     * @protected
     */
    value: function defineBoolean() {
      return {
        type: 'boolean'
      };
    }
  }, {
    key: 'defineJson',

    /**
     * Define a json mapping.
     *
     * @protected
     */
    value: function defineJson() {
      return {
        type: 'object',
        enabled: false
      };
    }
  }]);

  return LeveldbMigrator;
})();

exports['default'] = LeveldbMigrator;
module.exports = exports['default'];