'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

/**
 * LeveldbRepository
 * 
 * @class LeveldbReposirory
 */

var LeveldbRepository = (function () {
  /**
   * @param {LeveldbSerializer} serializer
   * @param {LeveldbAdapter}     adapter
   */

  function LeveldbRepository(serializer, adapter) {
    _classCallCheck(this, LeveldbRepository);

    this.serializer = serializer;
    this.adapter = adapter;
  }

  _createClass(LeveldbRepository, [{
    key: 'get',

    /**
     * Retrieve item
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {String} id
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function get(projectId, blueprint, id, projectVersion) {
      var client = this.adapter.getClient(projectId, projectVersion);
      var itemByIdDb = client.sublevel('item-by-id');
      return _bluebird2['default'].promisify(itemByIdDb.get)(id).then(function (item) {
        if (!item) {
          return null;
        }

        item = JSON.parse(item);
        _lodash2['default'].each(blueprint.columns, function (column, key) {
          if (_lodash2['default'].contains(['linestring', 'linestring[]', 'point', 'point[]', 'polygon', 'polygon[]'], column.type)) {
            if (item[key] && item[key].crs) {
              delete item[key].crs;
            }
          }
        });
        return item;
      });
    }
  }, {
    key: 'getAll',

    /**
     * Retrieve all items
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function getAll(projectId, blueprint, projectVersion) {
      return _bluebird2['default'].reject('not implemented');
    }
  }, {
    key: 'put',

    /**
     * Insert / update item.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {String} id
     * @param  {Object} item
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function put(projectId, blueprint, id, item, projectVersion) {
      // serialize the item
      var serializedItem = this.serializer.serialize(blueprint, item);

      // index the item
      var value = JSON.stringify(serializedItem);
      var client = this.adapter.getClient(projectId, projectVersion);
      var itemByIdDb = client.sublevel('item-by-id');
      var itemByTypeDb = client.sublevel('item-by-type');
      var table = itemByTypeDb.sublevel(blueprint.leveldb.type);

      return _bluebird2['default'].join(new _bluebird2['default'](function (resolve, reject) {
        itemByIdDb.put(id, value, function (err) {
          if (err) {
            return reject(err);
          }
          resolve();
        });
      }), new _bluebird2['default'](function (resolve, reject) {
        table.put(id, value, function (err) {
          if (err) {
            return reject(err);
          }
          resolve();
        });
      }));
    }
  }, {
    key: 'putMany',

    /**
     * Batch insert / update items.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Object} items
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function putMany(projectId, blueprint, items, projectVersion) {
      var _this = this;

      return _bluebird2['default'].reduce(items, function (memo, item) {
        return _bluebird2['default'].join(item.id, _this.put(projectId, blueprint, item.id, item, projectVersion));
      }, []).then(function (results) {
        return _lodash2['default'].object(results);
      });
    }
  }, {
    key: 'del',

    /**
     * Delete item.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Object} id
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
    value: function del(projectId, blueprint, id, projectVersion) {
      var client = this.adapter.getClient(projectId, projectVersion);

      var itemByIdDb = client.sublevel('item-by-id');
      var itemByTypeDb = client.sublevel('item-by-type');
      var table = itemByTypeDb.sublevel(blueprint.leveldb.type);

      return _bluebird2['default'].promisify(itemByIdDb.del)(id).then(function () {
        return _bluebird2['default'].promisify(table.del)(id);
      });
    }
  }]);

  return LeveldbRepository;
})();

exports['default'] = LeveldbRepository;
module.exports = exports['default'];