'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _leveldbAdapter = require('./leveldbAdapter');

var _leveldbAdapter2 = _interopRequireDefault(_leveldbAdapter);

var _leveldbSerializer = require('./leveldbSerializer');

var _leveldbSerializer2 = _interopRequireDefault(_leveldbSerializer);

var _leveldbRepository = require('./leveldbRepository');

var _leveldbRepository2 = _interopRequireDefault(_leveldbRepository);

var _leveldbDropper = require('./leveldbDropper');

var _leveldbDropper2 = _interopRequireDefault(_leveldbDropper);

var _leveldbSyncer = require('./leveldbSyncer');

var _leveldbSyncer2 = _interopRequireDefault(_leveldbSyncer);

var _leveldbFacade = require('./leveldbFacade');

var _leveldbFacade2 = _interopRequireDefault(_leveldbFacade);

var LeveldbServiceProvider = (function () {
  function LeveldbServiceProvider() {
    _classCallCheck(this, LeveldbServiceProvider);
  }

  _createClass(LeveldbServiceProvider, null, [{
    key: 'register',
    value: function register(app) {
      var adapter = new _leveldbAdapter2['default']('/tmp/level');
      var serializer = new _leveldbSerializer2['default']();
      var repository = new _leveldbRepository2['default'](serializer, adapter);
      var dropper = new _leveldbDropper2['default']('/tmp/level');
      var syncer = new _leveldbSyncer2['default'](adapter);
      var facade = new _leveldbFacade2['default'](repository, dropper, syncer);

      app.queue.consume('leveldb', function (command) {
        return facade[command.method].apply(facade, command.params || []);
      });
    }
  }]);

  return LeveldbServiceProvider;
})();

exports['default'] = LeveldbServiceProvider;
module.exports = exports['default'];