'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _eventStream = require('event-stream');

var _eventStream2 = _interopRequireDefault(_eventStream);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _dstoreHelpers = require('dstore-helpers');

var _levelWritestream = require('level-writestream');

var _levelWritestream2 = _interopRequireDefault(_levelWritestream);

var _highland = require('highland');

var _highland2 = _interopRequireDefault(_highland);

var _stream = require('stream');

var LeveldbSyncer = (function () {
  function LeveldbSyncer(adapter) {
    _classCallCheck(this, LeveldbSyncer);

    this.adapter = adapter;
  }

  _createClass(LeveldbSyncer, [{
    key: 'sync',

    /**
     * Sync data from the old index to the new one,
     * transforming items to the new version along the way when needed.
     *
     * @param  {String} projectId
     * @param  {Number} toProjectVersion
     * @param  {Object} fromBlueprints
     * @param  {Object} toBlueprints
     * @param  {Array} log
     *
     * @return {BBPromise}
     */
    value: function sync(projectId, toProjectVersion, fromBlueprints, toBlueprints, log) {
      var transformer, fromClient, toClient, keyedBlueprints;
      return regeneratorRuntime.async(function sync$(context$2$0) {
        while (1) switch (context$2$0.prev = context$2$0.next) {
          case 0:
            if (!(toProjectVersion === 1)) {
              context$2$0.next = 2;
              break;
            }

            return context$2$0.abrupt('return', _bluebird2['default'].resolve());

          case 2:
            transformer = new _dstoreHelpers.Transformer();
            fromClient = this.adapter.getClient(projectId, toProjectVersion - 1);
            toClient = this.adapter.getClient(projectId, toProjectVersion);
            keyedBlueprints = _lodash2['default'].map(toBlueprints, function (toBlueprint, blueprintId) {
              toBlueprint.key = blueprintId;
              return toBlueprint;
            });
            return context$2$0.abrupt('return', _bluebird2['default'].reduce(keyedBlueprints, function (memo, toBlueprint) {
              var fromBlueprint = fromBlueprints[toBlueprint.key];
              if (!fromBlueprint) {
                return _bluebird2['default'].resolve();
              }

              var fromItemByTypeDb = fromClient.sublevel('item-by-type');
              var fromTable = fromItemByTypeDb.sublevel(fromBlueprint.leveldb.type);
              var tableStream = fromTable.createReadStream();

              var toItemByTypeDb = toClient.sublevel('item-by-type');
              var toTable = toItemByTypeDb.sublevel(toBlueprint.leveldb.type);
              var toItemByIdDb = toClient.sublevel('item-by-id');
              (0, _levelWritestream2['default'])(toTable);
              (0, _levelWritestream2['default'])(toItemByIdDb);
              var toTableWriteStream = toTable.createWriteStream();
              var toItemByIdWriteStream = toItemByIdDb.createWriteStream();

              var transform = _eventStream2['default'].through(function (data) {
                var item = JSON.parse(data.value);
                var transformedItem = transformer.transform(log, fromBlueprint.leveldb.type, item, toProjectVersion - 1, toProjectVersion);
                if (transformedItem !== null) {
                  this.emit('data', {
                    key: data.key,
                    value: JSON.stringify(transformedItem)
                  });
                }
              });

              return new _bluebird2['default'](function (resolve) {
                var stream = tableStream.pipe(transform);

                var second = (0, _highland2['default'])(tableStream).fork();
                second.pipe(toTableWriteStream).on('finish', resolve);

                stream.pipe(toItemByIdWriteStream);
              });
            }, []));

          case 7:
          case 'end':
            return context$2$0.stop();
        }
      }, null, this);
    }
  }]);

  return LeveldbSyncer;
})();

exports['default'] = LeveldbSyncer;
module.exports = exports['default'];