import level from 'level-party';
import sublevel from 'level-sublevel';
import BBPromise from 'bluebird';
import mkdirp from 'mkdirp';

/**
 * LeveldbAdapter
 * 
 * @class LeveldbAdapter
 */
class LeveldbAdapter {

  /**
   * constructor
   * 
   * @param {String} path
   */
  constructor(path) {
    this.path = path;
    this.connections = {};
    mkdirp(this.path);
  }

  /**
   * Get the level client.
   *
   * @param  {String} projectId
   * @param  {Number} projectVersion
   *
   * @return {LeveldbClient}
   */
  getClient(projectId, projectVersion) {
    if (!this.connections[projectId + projectVersion]) {
      this.connections[projectId + projectVersion] = sublevel(level(this.path + '/' + projectId + 'v' + projectVersion));
    }
    return this.connections[projectId + projectVersion];
  }

  /**
   * Closes all connections
   */
  closeConnections() {
    Object.keys(this.connections).forEach((connectionKey) => {
      this.connections[connectionKey].close();
    });
  }

}

export default LeveldbAdapter;
