'use strict';

import _ from 'lodash';
import BBPromise from 'bluebird';
var rmRF = BBPromise.promisify(require('rimraf'));

/**
 * LeveldbDropper
 * 
 * @class LeveldbDropper
 * 
 * @param {String} path
 */
class LeveldbDropper {
  constructor(path) {
    this.path = path;
  }

  /**
   * Create / migrate database.
   *
   * @param  {String} projectId
   * @param  {Number} projectVersion
   *
   * @return {BBPromise}
   */
  drop(projectId, projectVersion) {
    var db = projectId + 'v' + projectVersion;
    return rmRF(this.path + '/' + db)
      .catch(function () {
        // db doesn't exist
        // noop
      });
  }

}

export default LeveldbDropper;


