import LeveldbAdapter from './leveldbAdapter';
import LeveldbSerializer from './leveldbSerializer';
import LeveldbRepository from './leveldbRepository';
import LeveldbDropper from './leveldbDropper';
import LeveldbSyncer from './leveldbSyncer';
import LeveldbFacade from './leveldbFacade';

class LeveldbServiceProvider {
  
  static register(app) {
    let adapter = new LeveldbAdapter('/tmp/level');
    let serializer = new LeveldbSerializer();
    let repository = new LeveldbRepository(serializer, adapter);
    let dropper = new LeveldbDropper('/tmp/level');
    let syncer = new LeveldbSyncer(adapter);
    let facade = new LeveldbFacade(repository, dropper, syncer);
    
    app.queue.consume('leveldb', (command) => {
      return facade[command.method].apply(facade, command.params || []);
    });
  }

}

export default LeveldbServiceProvider;
