'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _knex = require('knex');

var _knex2 = _interopRequireDefault(_knex);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

/**
 * PostgresqlAdapter
 *
 * @class PostgresqlAdapter
 *
 * @param {Object} config The postgresql connection configuration
 */

var PostgresqlAdapter = (function () {
  function PostgresqlAdapter(config) {
    _classCallCheck(this, PostgresqlAdapter);

    this.config = config;
    this.connections = {};
  }

  /**
   * Get the postgresql client.
   *
   * @param  {String} projectId
   * @param  {Number} projectVersion
   *
   * @return {PostgresqlClient}
   */

  _createClass(PostgresqlAdapter, [{
    key: 'getClient',
    value: function getClient(projectId, projectVersion) {
      if (!this.connections[projectId + projectVersion]) {
        var options = {
          client: 'postgresql',
          connection: {
            host: this.config.host,
            port: this.config.port,
            user: this.config.username,
            password: this.config.password,
            database: projectId + (projectVersion ? 'v' + projectVersion : '')
          },
          pool: {
            min: 0,
            max: 1
          }
        };
        this.connections[projectId + projectVersion] = (0, _knex2['default'])(options);
      }
      return this.connections[projectId + projectVersion];
    }
  }]);

  return PostgresqlAdapter;
})();

exports['default'] = PostgresqlAdapter;
module.exports = exports['default'];