'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _pg = require('pg');

var _pg2 = _interopRequireDefault(_pg);

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

_bluebird2['default'].promisifyAll(_pg2['default']);

/**
 * PostgresqlDropper
 *
 * @class PostgresqlDropper
 *
 * @param {Object} config
 */

var PostgresqlDropper = (function () {
  function PostgresqlDropper(config) {
    _classCallCheck(this, PostgresqlDropper);

    this.config = config;
  }

  /**
   * Create / migrate database.
   *
   * @param  {String} projectId
   * @param  {Number} projectVersion
   *
   * @return {BBPromise}
   */

  _createClass(PostgresqlDropper, [{
    key: 'drop',
    value: function drop(projectId, projectVersion) {
      var connectionString, client, database, dropConnectionsResult, dropDbResult;
      return regeneratorRuntime.async(function drop$(context$2$0) {
        while (1) switch (context$2$0.prev = context$2$0.next) {
          case 0:
            connectionString = 'postgresql://' + this.config.username + ':' + this.config.password + '@' + this.config.host + ':' + this.config.port + '/postgres';
            context$2$0.next = 3;
            return regeneratorRuntime.awrap(this.getConnection(connectionString));

          case 3:
            client = context$2$0.sent;
            database = projectId + 'v' + String(projectVersion);
            context$2$0.next = 7;
            return regeneratorRuntime.awrap(client.queryAsync('SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE datname = \'' + database + '\''));

          case 7:
            dropConnectionsResult = context$2$0.sent;
            context$2$0.prev = 8;
            context$2$0.next = 11;
            return regeneratorRuntime.awrap(client.queryAsync('DROP DATABASE ' + database));

          case 11:
            dropDbResult = context$2$0.sent;
            context$2$0.next = 17;
            break;

          case 14:
            context$2$0.prev = 14;
            context$2$0.t0 = context$2$0['catch'](8);

            console.error('If the error says the db didn\'t exist, ignore this', context$2$0.t0);

          case 17:
            return context$2$0.abrupt('return', this.connectionCloser());

          case 18:
          case 'end':
            return context$2$0.stop();
        }
      }, null, this, [[8, 14]]);
    }
  }, {
    key: 'getConnection',
    value: function getConnection(connectionString) {
      var _this = this;

      return _pg2['default'].connectAsync(connectionString).spread(function (client, done) {
        _this.connectionCloser = done;
        return client;
      });
    }
  }]);

  return PostgresqlDropper;
})();

exports['default'] = PostgresqlDropper;
module.exports = exports['default'];