'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

/**
 * PostgresqlFacade
 * 
 * @class PostgresqlFacade
 *
 */

var PostgresqlFacade = (function () {

  /**
   * @param {Repository} repository
   * @param {Migrator}   migrator
   * @param {Dropper}    dropper
   * @param {Syncer}     syncer
   */

  function PostgresqlFacade(repository, migrator, dropper, syncer) {
    _classCallCheck(this, PostgresqlFacade);

    this.repository = repository;
    this.migrator = migrator;
    this.dropper = dropper;
    this.syncer = syncer;
  }

  /**
   * Retrieve item
   *
   * @param  {String} projectId
   * @param  {Object} blueprint
   * @param  {String} id
   * @param  {Number} projectVersion
   *
   * @return {BBPromise}
   */

  _createClass(PostgresqlFacade, [{
    key: 'get',
    value: function get(projectId, blueprint, id, projectVersion) {
      return this.repository.get(projectId, blueprint, id, projectVersion);
    }

    /**
     * Retrieve all items
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
  }, {
    key: 'getAll',
    value: function getAll(projectId, blueprint, projectVersion) {
      return this.repository.getAll(projectId, blueprint, projectVersion);
    }

    /**
     * Insert / update item.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {String} id
     * @param  {Object} item
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
  }, {
    key: 'put',
    value: function put(projectId, blueprint, id, item, projectVersion) {
      return this.repository.put(projectId, blueprint, id, item, projectVersion);
    }

    /**
     * Batch insert / update items.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Object} items
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
  }, {
    key: 'putMany',
    value: function putMany(projectId, blueprint, items, projectVersion) {
      return this.repository.putMany(projectId, blueprint, items, projectVersion);
    }

    /**
     * Delete item.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Object} id
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
  }, {
    key: 'del',
    value: function del(projectId, blueprint, id, projectVersion) {
      return this.repository.del(projectId, blueprint, id, projectVersion);
    }

    /**
     * Sync data from the old index to the new one,
     * transforming items to the new version along the way when needed.
     *
     * @param  {String} projectId
     * @param  {Number} toProjectVersion
     * @param  {Object} fromBlueprints
     * @param  {Object} toBlueprints
     * @param  {Object} log
     *
     * @return {BBPromise}
     */
  }, {
    key: 'sync',
    value: function sync(projectId, toProjectVersion, fromBlueprints, toBlueprints, log) {
      return this.syncer.sync(projectId, toProjectVersion, fromBlueprints, toBlueprints, log);
    }

    /**
     * Create a new postgresql index and put the mapping.
     *
     * @param  {String} projectId
     * @param  {Number} projectVersion
     * @param  {Object} blueprints
     *
     * @return {BBPromise}
     */
  }, {
    key: 'migrate',
    value: function migrate(projectId, projectVersion, blueprints) {
      return this.migrator.migrate(projectId, projectVersion, blueprints);
    }

    /**
     * Drop postgresql index.
     *
     * @param  {String} projectId
     * @param  {Number} projectVersion
     * 
     * @return {BBPromise}
     */
  }, {
    key: 'drop',
    value: function drop(projectId, projectVersion) {
      return this.dropper.drop(projectId, projectVersion);
    }

    /**
     * Serialize an item to make it compatible with postgresql.
     *
     * @param  {Object} blueprint
     * @param  {Object} item
     * 
     * @return {Object} The serialized item
     */
  }, {
    key: 'serialize',
    value: function serialize(blueprint, item) {
      return this.serializer.serializer(blueprint, item);
    }
  }]);

  return PostgresqlFacade;
})();

exports['default'] = PostgresqlFacade;
module.exports = exports['default'];