'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _dstoreHelpers = require('dstore-helpers');

var _pg = require('pg');

var _pg2 = _interopRequireDefault(_pg);

_bluebird2['default'].promisifyAll(_pg2['default']);

/**
 * PostgresqlMigrator
 *
 * @class PostgresqlMigrator
 */

var PostgresqlMigrator = (function () {
  /**
   * @param {PostgresqlAdapter} adapter
   */

  function PostgresqlMigrator(adapter, config) {
    _classCallCheck(this, PostgresqlMigrator);

    this.adapter = adapter;
    this.config = config;
  }

  /**
   * Create / migrate database.
   *
   * @param  {String} projectId
   * @param  {Number} projectVersion
   *
   * @return {BBPromise.<undefined>}
   */

  _createClass(PostgresqlMigrator, [{
    key: 'migrate',
    value: function migrate(projectId, projectVersion, blueprints) {
      var connectionString, client;
      return regeneratorRuntime.async(function migrate$(context$2$0) {
        while (1) switch (context$2$0.prev = context$2$0.next) {
          case 0:
            connectionString = 'postgresql://' + this.config.username + ':' + this.config.password + '@' + this.config.host + ':' + this.config.port + '/';
            context$2$0.next = 3;
            return regeneratorRuntime.awrap(this.checkExtensions(connectionString));

          case 3:
            context$2$0.next = 5;
            return regeneratorRuntime.awrap(this.createDatabase(connectionString, projectId, projectVersion));

          case 5:
            context$2$0.next = 7;
            return regeneratorRuntime.awrap(this.getDatabaseClient(projectId, projectVersion));

          case 7:
            client = context$2$0.sent;
            context$2$0.next = 10;
            return regeneratorRuntime.awrap(this.createTables(client, blueprints));

          case 10:
            return context$2$0.abrupt('return', {
              success: true
            });

          case 11:
          case 'end':
            return context$2$0.stop();
        }
      }, null, this);
    }
  }, {
    key: 'checkExtensions',
    value: function checkExtensions(connectionString) {
      return _pg2['default'].connectAsync(connectionString + 'template_postgis').spread(function (postgisTemplateConnection, done) {
        return postgisTemplateConnection.queryAsync('SELECT extname, extversion from pg_extension').then(function (result) {
          var promise = _bluebird2['default'].resolve();

          var extensions = _lodash2['default'].pluck(result.rows, 'extname');
          if (!_lodash2['default'].contains(extensions, 'postgis')) {
            console.log('"postgis" extension missing, installing it.');
            promise = promise.then(function () {
              return postgisTemplateConnection.queryAsync('CREATE EXTENSION postgis');
            });
          }

          if (!_lodash2['default'].contains(extensions, 'uuid-ossp')) {
            console.log('"uuid-ossp" extension missing, installing it.');
            promise = promise.then(function () {
              return postgisTemplateConnection.queryAsync('CREATE EXTENSION "uuid-ossp"');
            });
          }

          return promise;
        })['finally'](function () {
          return done();
        });
      });
    }

    /**
     * Creates a new database for given projectId and project version.
     *
     * @param  {String} connectionString The postgresql connectionString
     * @param  {String} projectId        The project's identifier
     * @param  {Number} projectVersion   The project version
     */
  }, {
    key: 'createDatabase',
    value: function createDatabase(connectionString, projectId, projectVersion) {
      return _pg2['default'].connectAsync(connectionString + 'template_postgis').spread(function (postgresConnection, done) {
        return postgresConnection.queryAsync('CREATE DATABASE ' + projectId + 'v' + projectVersion + ' TEMPLATE=template_postgis')['catch'](function (err) {
          console.error('Error while creating database', err);
          throw err;
        })['finally'](function () {
          return done();
        });
      });
    }

    /**
     * Retrieves the database client for given projectId and project version.
     *
     * @param  {String} projectId          The project's identifier
     * @param  {Number} projectVersion     The project version
     */
  }, {
    key: 'getDatabaseClient',
    value: function getDatabaseClient(projectId, projectVersion) {
      return this.adapter.getClient(projectId, projectVersion);
    }

    /**
     * Creates tables in database based on the given blueprints.
     *
     * @param  {PostgresqlClient}  client
     * @param  {Object}            blueprints The blueprints
     */
  }, {
    key: 'createTables',
    value: function createTables(client, blueprints) {
      var _this = this;

      var promises = _lodash2['default'].map(blueprints, function (blueprint) {
        return client.schema.createTable(blueprint.postgresql.table, function (table) {
          _lodash2['default'].each(blueprint.columns, function (column, columnKey) {
            var chain = _this['define' + _dstoreHelpers.helpers.capitalizeFirstLetter(column.type).replace('[]', 'Array')](table, columnKey);

            if (column.index) {
              if (column.index_type) {
                chain.index(null, column.index_type);
              } else {
                chain.index();
              }
            }

            if (column.primary) {
              chain.primary();
            }

            if (column.unique) {
              chain.unique();
            }

            if (column.references) {
              chain.inTable(column.references.table).references(column.references.column);
            }

            if (column.unsigned) {
              chain.unsigned();
            }

            if (column.nullable === false) {
              chain.notNullable();
            }

            if (column.comment) {
              chain.comment(column.comment);
            }
          });
        })
        // triger knex.js's promise strategy
        .then(function (res) {
          return res;
        }, function (err) {
          console.error('error while creating tables', err);
        });
      });

      return _bluebird2['default'].all(promises);
    }

    /**
     * Defines an INTEGER column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineInteger',
    value: function defineInteger(table, columnKey) {
      return table.integer(columnKey);
    }

    /**
     * Defines an INTEGER[] column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineIntegerArray',
    value: function defineIntegerArray(table, columnKey) {
      return table.specificType(columnKey, 'INTEGER[]');
    }

    /**
     * Defines an UUID column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineUuid',
    value: function defineUuid(table, columnKey) {
      return table.uuid(columnKey);
    }

    /**
     * Defines an UUID[] column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineUuidArray',
    value: function defineUuidArray(table, columnKey) {
      return table.specificType(columnKey, 'UUID[]');
    }

    /**
     * Defines an STRING column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineString',
    value: function defineString(table, columnKey) {
      return table.string(columnKey);
    }

    /**
     * Defines an STRING[] column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineStringArray',
    value: function defineStringArray(table, columnKey) {
      return table.specificType(columnKey, 'VARCHAR[]');
    }

    /**
     * Defines an TEXT column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineText',
    value: function defineText(table, columnKey) {
      return table.text(columnKey);
    }

    /**
     * Defines an TEXT[] column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineTextArray',
    value: function defineTextArray(table, columnKey) {
      return table.specificType(columnKey, 'TEXT[]');
    }

    /**
     * Defines an DATETIME column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineDatetime',
    value: function defineDatetime(table, columnKey) {
      return table.dateTime(columnKey);
    }

    /**
     * Defines an DATETIME[] column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineDatetimeArray',
    value: function defineDatetimeArray(table, columnKey) {
      return table.specificType(columnKey, 'TIMESTAMP WITH TIME ZONE[]');
    }

    /**
     * Defines an DATE column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineDate',
    value: function defineDate(table, columnKey) {
      return table.date(columnKey);
    }

    /**
     * Defines an DATE[] column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineDateArray',
    value: function defineDateArray(table, columnKey) {
      return table.specificType(columnKey, 'DATE[]');
    }

    /**
     * Defines an REAL column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineFloat',
    value: function defineFloat(table, columnKey) {
      return table.float(columnKey);
    }

    /**
     * Defines an REAL[] column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineFloatArray',
    value: function defineFloatArray(table, columnKey) {
      return table.specificType(columnKey, 'REAL[]');
    }

    /**
     * Defines an GEOMETRY column of type Point on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'definePoint',
    value: function definePoint(table, columnKey) {
      return table.specificType(columnKey, 'geometry(Point,4326)');
    }

    /**
     * Defines an GEOMETRY column of type MultiPoint on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'definePointArray',
    value: function definePointArray(table, columnKey) {
      return table.specificType(columnKey, 'geometry(MultiPoint,4326)');
    }

    /**
     * Defines an GEOMETRY column of type LineString on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineLinestring',
    value: function defineLinestring(table, columnKey) {
      return table.specificType(columnKey, 'geometry(LineString,4326)');
    }

    /**
     * Defines an GEOMETRY column of type MultiLineString on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineLinestringArray',
    value: function defineLinestringArray(table, columnKey) {
      return table.specificType(columnKey, 'geometry(MultiLineString,4326)');
    }

    /**
     * Defines an GEOMETRY column of type Polygon on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'definePolygon',
    value: function definePolygon(table, columnKey) {
      return table.specificType(columnKey, 'geometry(Polygon,4326)');
    }

    /**
     * Defines an GEOMETRY column of type MultiPolygon on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'definePolygonArray',
    value: function definePolygonArray(table, columnKey) {
      return table.specificType(columnKey, 'geometry(MultiPolygon,4326)');
    }

    /**
     * Defines an BOOLEAN column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineBoolean',
    value: function defineBoolean(table, columnKey) {
      return table.boolean(columnKey);
    }

    /**
     * Defines an BOOLEAN[] column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineBooleanArray',
    value: function defineBooleanArray(table, columnKey) {
      return table.specificType(columnKey, 'BOOLEAN[]');
    }

    /**
     * Defines a JSON column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineJson',
    value: function defineJson(table, columnKey) {
      return table.json(columnKey);
    }

    /**
     * Defines a JSON[] column on given table.
     *
     * @protected
     * @param  {Object} table     Knex.js table object (given through createTable's callback)
     * @param  {String} columnKey Name of the column
     */
  }, {
    key: 'defineJsonArray',
    value: function defineJsonArray(table, columnKey) {
      return table.specificType(columnKey, 'JSON[]');
    }
  }]);

  return PostgresqlMigrator;
})();

exports['default'] = PostgresqlMigrator;
module.exports = exports['default'];