'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var knex = require('knex')({ dialect: 'postgres' });

/**
 * PostgresqlRepository
 * 
 * @class PostgresqlReposirory
 */

var PostgresqlRepository = (function () {
  /**
   * @param {PostgresqlSerializer} serializer
   * @param {PostgresqlAdapter}     adapter
   */

  function PostgresqlRepository(serializer, adapter) {
    _classCallCheck(this, PostgresqlRepository);

    this.serializer = serializer;
    this.adapter = adapter;
  }

  /**
   * Retrieve item
   *
   * @param  {String} projectId
   * @param  {Object} blueprint
   * @param  {String} id
   * @param  {Number} projectVersion
   *
   * @return {BBPromise}
   */

  _createClass(PostgresqlRepository, [{
    key: 'get',
    value: function get(projectId, blueprint, id, projectVersion) {
      var client = this.adapter.getClient(projectId, projectVersion);
      var selects = this.blueprintToSelects(blueprint);
      return client.table(blueprint.postgresql.table).select(selects).where({
        id: id
      }).first(selects)
      // triggers knex.js's promise strategy
      .then(function (res) {
        _lodash2['default'].each(blueprint.columns, function (column, key) {
          if (_lodash2['default'].contains(['linestring', 'linestring[]', 'point', 'point[]', 'polygon', 'polygon[]'], column.type)) {
            if (res[key] !== null) {
              res[key] = JSON.parse(res[key]);
            }
          }
        });

        return res;
      });
    }

    /**
     * Retrieve all items
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
  }, {
    key: 'getAll',
    value: function getAll(projectId, blueprint, projectVersion) {
      return _bluebird2['default'].reject(new Error('not implemented'));
    }

    /**
     * Insert / update item.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {String} id
     * @param  {Object} item
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
  }, {
    key: 'put',
    value: function put(projectId, blueprint, id, item, projectVersion) {
      var serializedItem, client, exists;
      return regeneratorRuntime.async(function put$(context$2$0) {
        while (1) switch (context$2$0.prev = context$2$0.next) {
          case 0:
            serializedItem = this.serializer.serialize(blueprint, item);
            client = this.adapter.getClient(projectId, projectVersion);
            context$2$0.next = 4;
            return regeneratorRuntime.awrap(this.itemExists(client, blueprint, id));

          case 4:
            exists = context$2$0.sent;

            if (!exists) {
              context$2$0.next = 11;
              break;
            }

            context$2$0.next = 8;
            return regeneratorRuntime.awrap(this.updateItem(client, blueprint, id, serializedItem));

          case 8:
            return context$2$0.abrupt('return', context$2$0.sent);

          case 11:
            context$2$0.next = 13;
            return regeneratorRuntime.awrap(this.insertItem(client, blueprint, serializedItem));

          case 13:
            return context$2$0.abrupt('return', context$2$0.sent);

          case 14:
          case 'end':
            return context$2$0.stop();
        }
      }, null, this);
    }

    /**
     * Batch insert / update items.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Object} items
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
  }, {
    key: 'putMany',
    value: function putMany(projectId, blueprint, items, projectVersion) {
      var _this = this;

      // serialize the item
      return _bluebird2['default'].map(items, function (item) {
        return _this.put(projectId, blueprint, item.id, item, projectVersion);
      });
    }

    /**
     * Delete item.
     *
     * @param  {String} projectId
     * @param  {Object} blueprint
     * @param  {Object} id
     * @param  {Number} projectVersion
     *
     * @return {BBPromise}
     */
  }, {
    key: 'del',
    value: function del(projectId, blueprint, id, projectVersion) {
      // retrieve the knex.js client for the given version
      var client = this.adapter.getClient(projectId, projectVersion);
      return client.table(blueprint.postgresql.table).where({
        id: id
      }).del()
      // triggers knex.js's promise strategy
      .then(function (res) {
        return res;
      });
    }

    /**
     * Checks if an item already exists in the database.
     * 
     * @param  {PostgresqlClient} client      The knex client
     * @param  {Object}           blueprint   Blueprint options
     * @param  {Object}           id          The id of the item
     * 
     * @return {Promise} Promise resolving true or false (exists or doesn't exist).
     */
  }, {
    key: 'itemExists',
    value: function itemExists(client, blueprint, id) {
      return client.table(blueprint.postgresql.table).first().where({
        id: id
      }).then(function (row) {
        return !!row;
      });
    }

    /**
     * Updates an item in the database.
     *
     * @param  {PostgresqlClient} client            The knex client
     * @param  {Object}           blueprint         Blueprint options
     * @param  {Object}           id                The id of the item
     * @param  {Object}           serializedItem    The serialized item
     * 
     * @return {Promise}
     */
  }, {
    key: 'updateItem',
    value: function updateItem(client, blueprint, id, serializedItem) {
      return client.table(blueprint.postgresql.table).where({
        id: id
      }).update(serializedItem)
      // triggers knex.js's promise strategy
      .then(function (res) {
        return res;
      });
    }

    /**
     * Inserts a new item into the database.
     * 
     * @param  {PostgresqlClient} client          The knex client
     * @param  {Object}           blueprint       Blueprint options
     * @param  {Object}           compatibleItem  The serialized item
     * 
     * @return {Promise}
     */
  }, {
    key: 'insertItem',
    value: function insertItem(client, blueprint, serializedItem) {
      return client.table(blueprint.postgresql.table).insert(serializedItem)
      // triggers knex.js's promise strategy
      .then(function (res) {
        return res;
      });
    }
  }, {
    key: 'blueprintToSelects',
    value: function blueprintToSelects(blueprint) {
      var selects = ['*'];

      _lodash2['default'].each(blueprint.columns, function (column, key) {
        if (_lodash2['default'].contains(['linestring', 'linestring[]', 'point', 'point[]', 'polygon', 'polygon[]'], column.type)) {
          selects.push(knex.raw('ST_AsGeoJson(' + key + ') as ' + key));
        }

        if (column.type === 'datetime') {
          selects.push(knex.raw('to_char(' + key + ', \'yyyy-MM-dd hh:mi:ss\') as ' + key));
        }

        if (column.type === 'date') {
          selects.push(knex.raw('to_char(' + key + ', \'yyyy-MM-dd\') as ' + key));
        }
      });

      return selects;
    }
  }]);

  return PostgresqlRepository;
})();

exports['default'] = PostgresqlRepository;
module.exports = exports['default'];

// serialize the item

// retrieve the knex.js client for the given version

// check if the item exists

// update the item

// insert the item