'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _dstoreHelpers = require('dstore-helpers');

var knex = require('knex')({ dialect: 'postgres' });
var st = require('knex-postgis')(knex);

/**
 * PostgresqlSerializer
 * 
 * @class PostgresqlSerializer
 * @extends {Serializer}
 */

var PostgresqlSerializer = (function (_Serializer) {
  _inherits(PostgresqlSerializer, _Serializer);

  function PostgresqlSerializer() {
    _classCallCheck(this, PostgresqlSerializer);

    _get(Object.getPrototypeOf(PostgresqlSerializer.prototype), 'constructor', this).apply(this, arguments);
  }

  _createClass(PostgresqlSerializer, [{
    key: 'serialize',

    /**
     * Serialize item for postgresql.
     *
     * @param  {Object} blueprint
     * @param  {Object} item
     * 
     * @return {Object} The serialized item
     */
    value: function serialize(blueprint, item) {
      return this.serializeItem(blueprint, item);
    }

    /**
     * Serialize a point.
     *
     * @protected
     * @param  {string} value
     */
  }, {
    key: 'serializePoint',
    value: function serializePoint(value) {
      return this.serializeGeoJSON(value);
    }

    /**
     * Serialize a point array.
     *
     * @protected
     * @param  {string} value
     */
  }, {
    key: 'serializePointArray',
    value: function serializePointArray(value) {
      return this.serializeGeoJSON(value);
    }

    /**
     * Serialize a linestring.
     *
     * @protected
     * @param  {string} value
     */
  }, {
    key: 'serializeLinestring',
    value: function serializeLinestring(value) {
      return this.serializeGeoJSON(value);
    }

    /**
     * Serialize a linestring array.
     *
     * @protected
     * @param  {string} value
     */
  }, {
    key: 'serializeLinestringArray',
    value: function serializeLinestringArray(value) {
      return this.serializeGeoJSON(value);
    }

    /**
     * Serialize a polygon.
     *
     * @protected
     * @param  {string} value
     */
  }, {
    key: 'serializePolygon',
    value: function serializePolygon(value) {
      return this.serializeGeoJSON(value);
    }

    /**
     * Serialize a polygon array.
     *
     * @protected
     * @param  {string} value
     */
  }, {
    key: 'serializePolygonArray',
    value: function serializePolygonArray(value) {
      return this.serializeGeoJSON(value);
    }

    /**
     * Serialize to geojson.
     *
     * @protected
     * @param  {string} value
     */
  }, {
    key: 'serializeGeoJSON',
    value: function serializeGeoJSON(value) {
      if (!value.crs) {
        value.crs = {
          type: 'name',
          properties: { name: 'EPSG:4326' }
        };
      }

      return st.geomFromGeoJSON(value);
    }
  }]);

  return PostgresqlSerializer;
})(_dstoreHelpers.Serializer);

exports['default'] = PostgresqlSerializer;
module.exports = exports['default'];