'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _postgresqlAdapter = require('./postgresqlAdapter');

var _postgresqlAdapter2 = _interopRequireDefault(_postgresqlAdapter);

var _postgresqlSerializer = require('./postgresqlSerializer');

var _postgresqlSerializer2 = _interopRequireDefault(_postgresqlSerializer);

var _postgresqlRepository = require('./postgresqlRepository');

var _postgresqlRepository2 = _interopRequireDefault(_postgresqlRepository);

var _postgresqlMigrator = require('./postgresqlMigrator');

var _postgresqlMigrator2 = _interopRequireDefault(_postgresqlMigrator);

var _postgresqlDropper = require('./postgresqlDropper');

var _postgresqlDropper2 = _interopRequireDefault(_postgresqlDropper);

var _postgresqlSyncer = require('./postgresqlSyncer');

var _postgresqlSyncer2 = _interopRequireDefault(_postgresqlSyncer);

var _postgresqlFacade = require('./postgresqlFacade');

var _postgresqlFacade2 = _interopRequireDefault(_postgresqlFacade);

var PostgresqlServiceProvider = (function () {
  function PostgresqlServiceProvider() {
    _classCallCheck(this, PostgresqlServiceProvider);
  }

  _createClass(PostgresqlServiceProvider, null, [{
    key: 'register',
    value: function register(app) {
      var config = app.config.postgresql;
      var adapter = new _postgresqlAdapter2['default'](config);
      var serializer = new _postgresqlSerializer2['default']();
      var repository = new _postgresqlRepository2['default'](serializer, adapter);
      var migrator = new _postgresqlMigrator2['default'](adapter, config);
      var dropper = new _postgresqlDropper2['default'](config);
      var syncer = new _postgresqlSyncer2['default'](config, adapter, serializer);
      var facade = new _postgresqlFacade2['default'](repository, migrator, dropper, syncer);

      app.queue.consume('postgresql', function (command) {
        return facade[command.method].apply(facade, command.params || []);
      });
    }
  }]);

  return PostgresqlServiceProvider;
})();

exports['default'] = PostgresqlServiceProvider;
module.exports = exports['default'];