'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _pg = require('pg');

var _pg2 = _interopRequireDefault(_pg);

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _eventStream = require('event-stream');

var _eventStream2 = _interopRequireDefault(_eventStream);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _dstoreHelpers = require('dstore-helpers');

var _pgQueryStream = require('pg-query-stream');

var _pgQueryStream2 = _interopRequireDefault(_pgQueryStream);

_bluebird2['default'].promisifyAll(_pg2['default']);

var PostgresqlSyncer = (function () {
  function PostgresqlSyncer(config, adapter, serializer) {
    _classCallCheck(this, PostgresqlSyncer);

    this.config = config;
    this.adapter = adapter;
    this.serializer = serializer;
  }

  /**
   * Sync data from the old index to the new one,
   * transforming items to the new version along the way when needed.
   *
   * @param  {String} projectId
   * @param  {Number} toProjectVersion
   * @param  {Object} fromBlueprints
   * @param  {Object} toBlueprints
   * @param  {Array} log
   *
   * @return {BBPromise}
   */

  _createClass(PostgresqlSyncer, [{
    key: 'sync',
    value: function sync(projectId, toProjectVersion, fromBlueprints, toBlueprints, log) {
      var self, transformer, fromConnectionString, fromClient, toClient, keyedBlueprints;
      return regeneratorRuntime.async(function sync$(context$2$0) {
        var _this = this;

        while (1) switch (context$2$0.prev = context$2$0.next) {
          case 0:
            self = this;
            transformer = new _dstoreHelpers.Transformer();
            fromConnectionString = 'postgresql://' + this.config.username + ':' + this.config.password + '@' + this.config.host + ':' + this.config.port + '/' + projectId + 'v' + (toProjectVersion - 1);
            context$2$0.next = 5;
            return regeneratorRuntime.awrap(this.getConnection(fromConnectionString));

          case 5:
            fromClient = context$2$0.sent;

            fromClient.connection.stream.setMaxListeners(100);
            // retrieve the knex.js client for the new project version
            toClient = this.adapter.getClient(projectId, toProjectVersion);
            keyedBlueprints = _lodash2['default'].map(toBlueprints, function (blueprint, blueprintId) {
              blueprint.id = blueprintId;
              return blueprint;
            });
            return context$2$0.abrupt('return', _bluebird2['default'].reduce(keyedBlueprints, function (memo, blueprint) {
              var fromBlueprint = fromBlueprints[blueprint.id];
              if (!fromBlueprint) {
                return _bluebird2['default'].resolve();
              }
              var transformItem = _eventStream2['default'].through(function (item) {
                var transformedItem = transformer.transform(log, blueprint.id, item, toProjectVersion - 1, toProjectVersion);
                _lodash2['default'].each(blueprint.columns, function (column, columnKey) {
                  if (self.isGeoField(column.type)) {
                    if (transformedItem[columnKey]) {
                      transformedItem[columnKey] = JSON.parse(transformedItem[columnKey]);
                    }
                  }
                });
                if (transformedItem !== null) {
                  this.emit('data', transformedItem);
                }
              });

              var toStream = _eventStream2['default'].through(function (transformedItem) {
                var streamSelf = this;
                var serializedItem = self.serializer.serialize(blueprint, transformedItem);
                streamSelf.pause();
                toClient.table(blueprint.postgresql.table).insert(serializedItem)
                // triggers knex.js's promise strategy
                .then(function (res) {
                  streamSelf.resume();
                  return res;
                })['catch'](function (err) {
                  throw err;
                });
              });

              return new _bluebird2['default'](function (resolve, reject) {
                var query = new _pgQueryStream2['default']('SELECT ' + _this.blueprintToSelects(fromBlueprint) + ' FROM ' + fromBlueprint.postgresql.table);
                var fromStream = fromClient.query(query);
                fromStream.pipe(transformItem).pipe(toStream).on('end', resolve).on('error', function (err) {
                  throw err;
                });
              });
            }, []));

          case 10:
          case 'end':
            return context$2$0.stop();
        }
      }, null, this);
    }
  }, {
    key: 'getConnection',
    value: function getConnection(connectionString) {
      var _this2 = this;

      return _pg2['default'].connectAsync(connectionString).spread(function (client, done) {
        _this2.connectionCloser = done;
        return client;
      });
    }
  }, {
    key: 'blueprintToSelects',
    value: function blueprintToSelects(blueprint) {
      var _this3 = this;

      var selects = ['*'];

      _lodash2['default'].each(blueprint.columns, function (column, key) {
        if (_this3.isGeoField(column.type)) {
          selects.push('ST_AsGeoJson(' + key + ') as ' + key);
        }

        if (column.type === 'datetime') {
          selects.push('to_char(' + key + ', \'yyyy-MM-dd hh:mi:ss\') as ' + key);
        }

        if (column.type === 'date') {
          selects.push('to_char(' + key + ', \'yyyy-MM-dd\') as ' + key);
        }
      });

      return selects.join(',');
    }
  }, {
    key: 'isGeoField',
    value: function isGeoField(type) {
      return _lodash2['default'].contains(['linestring', 'linestring[]', 'point', 'point[]', 'polygon', 'polygon[]'], type);
    }
  }]);

  return PostgresqlSyncer;
})();

exports['default'] = PostgresqlSyncer;
module.exports = exports['default'];