import knex from 'knex';
import BBPromise from 'bluebird';

/**
 * PostgresqlAdapter
 *
 * @class PostgresqlAdapter
 *
 * @param {Object} config The postgresql connection configuration
 */
class PostgresqlAdapter {

  constructor(config) {
    this.config = config;
    this.connections = {};
  }

  /**
   * Get the postgresql client.
   *
   * @param  {String} projectId
   * @param  {Number} projectVersion
   *
   * @return {PostgresqlClient}
   */
  getClient(projectId, projectVersion) {
    if (!this.connections[projectId + projectVersion]) {
      var options = {
        client: 'postgresql',
        connection: {
          host: this.config.host,
          port: this.config.port,
          user: this.config.username,
          password: this.config.password,
          database: projectId + (projectVersion ? 'v' + projectVersion : '')
        },
        pool: {
          min: 0,
          max: 1
        }
      };
      this.connections[projectId + projectVersion] = knex(options);
    }
    return this.connections[projectId + projectVersion];
  }

}

export default PostgresqlAdapter;
