import pg from 'pg';
import _ from 'lodash';
import BBPromise from 'bluebird';

BBPromise.promisifyAll(pg);

/**
 * PostgresqlDropper
 *
 * @class PostgresqlDropper
 *
 * @param {Object} config
 */
class PostgresqlDropper {
  constructor(config) {
    this.config = config;
  }

  /**
   * Create / migrate database.
   *
   * @param  {String} projectId
   * @param  {Number} projectVersion
   *
   * @return {BBPromise}
   */
  async drop(projectId, projectVersion) {
    let connectionString = 'postgresql://' + this.config.username + ':' + this.config.password + '@' + this.config.host + ':' + this.config.port + '/postgres';
    let client = await this.getConnection(connectionString);
    let database = projectId + 'v' + String(projectVersion);
    var dropConnectionsResult = await client.queryAsync('SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE datname = \'' + database + '\'');
    try {
      var dropDbResult = await client.queryAsync('DROP DATABASE ' + database);
    } catch (e) {
      console.error('If the error says the db didn\'t exist, ignore this', e);
    }

    return this.connectionCloser();
  }

  getConnection(connectionString) {
    return pg.connectAsync(connectionString)
      .spread((client, done) => {
        this.connectionCloser = done;
        return client;
      });
  }

}

export default PostgresqlDropper;
