import BBPromise from 'bluebird';
import { Serializer } from 'dstore-helpers';
var knex = require('knex')({dialect: 'postgres'});
var st = require('knex-postgis')(knex);

/**
 * PostgresqlSerializer
 * 
 * @class PostgresqlSerializer
 * @extends {Serializer}
 */
class PostgresqlSerializer extends Serializer {

  /**
   * Serialize item for postgresql.
   *
   * @param  {Object} blueprint
   * @param  {Object} item
   * 
   * @return {Object} The serialized item
   */
  serialize(blueprint, item) {
    return this.serializeItem(blueprint, item);
  }


  /**
   * Serialize a point.
   *
   * @protected
   * @param  {string} value
   */
  serializePoint(value) {
    return this.serializeGeoJSON(value);
  }

  /**
   * Serialize a point array.
   *
   * @protected
   * @param  {string} value
   */
  serializePointArray(value) {
    return this.serializeGeoJSON(value);
  }

  /**
   * Serialize a linestring.
   *
   * @protected
   * @param  {string} value
   */
  serializeLinestring(value) {
    return this.serializeGeoJSON(value);
  }

  /**
   * Serialize a linestring array.
   *
   * @protected
   * @param  {string} value
   */
  serializeLinestringArray(value) {
    return this.serializeGeoJSON(value);
  }

  /**
   * Serialize a polygon.
   *
   * @protected
   * @param  {string} value
   */
  serializePolygon(value) {
    return this.serializeGeoJSON(value);
  }

  /**
   * Serialize a polygon array.
   *
   * @protected
   * @param  {string} value
   */
  serializePolygonArray(value) {
    return this.serializeGeoJSON(value);
  }

  /**
   * Serialize to geojson.
   *
   * @protected
   * @param  {string} value
   */
  serializeGeoJSON(value) {
    if ( ! value.crs) {
      value.crs = {
        type: 'name',
        properties: {name: 'EPSG:4326'}
      };
    }
    
    return st.geomFromGeoJSON(value);
  }

}

export default PostgresqlSerializer;
