import PostgresqlAdapter from './postgresqlAdapter';
import PostgresqlSerializer from './postgresqlSerializer';
import PostgresqlRepository from './postgresqlRepository';
import PostgresqlMigrator from './postgresqlMigrator';
import PostgresqlDropper from './postgresqlDropper';
import PostgresqlSyncer from './postgresqlSyncer';
import PostgresqlFacade from './postgresqlFacade';

class PostgresqlServiceProvider {
  
  static register(app) {
    let config = app.config.postgresql;
    let adapter = new PostgresqlAdapter(config);
    let serializer = new PostgresqlSerializer();
    let repository = new PostgresqlRepository(serializer, adapter);
    let migrator = new PostgresqlMigrator(adapter, config);
    let dropper = new PostgresqlDropper(config);
    let syncer = new PostgresqlSyncer(config, adapter, serializer);
    let facade = new PostgresqlFacade(repository, migrator, dropper, syncer);
    
    app.queue.consume('postgresql', (command) => {
      return facade[command.method].apply(facade, command.params || []);
    });
  }

}

export default PostgresqlServiceProvider;
