'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var mouse = function () {
  function mouse() {
    _classCallCheck(this, mouse);
  }

  _createClass(mouse, null, [{
    key: 'initialise',
    value: function initialise(element) {
      element.onMouseUp = onMouseUp;
      element.onMouseDown = onMouseDown;
      element.onMouseOver = onMouseOver;
      element.onMouseOut = onMouseOut;
      element.onMouseMove = onMouseMove;

      element.offMouseUp = offMousefUp;
      element.offMouseDown = offMousefDown;
      element.offMouseOver = offMousefOver;
      element.offMouseOut = offMousefOut;
      element.offMouseMove = offMousefMove;
    }
  }]);

  return mouse;
}();

module.exports = mouse;

function onMouseUp(mouseUpHandler, namespace) {
  this.on('mouseup', returnEventHandler(mouseUpHandler), namespace);
}
function onMouseDown(mouseDownHandler, namespace) {
  this.on('mousedown', returnEventHandler(mouseDownHandler), namespace);
}
function onMouseOver(mouseOverHandler, namespace) {
  this.on('mouseover', returnEventHandler(mouseOverHandler), namespace);
}
function onMouseOut(mouseOutHandler, namespace) {
  this.on('mouseout', returnEventHandler(mouseOutHandler), namespace);
}
function onMouseMove(mouseMoveHandler, namespace) {
  this.on('mousemove', returnEventHandler(mouseMoveHandler), namespace);
}

function offMousefUp(namespace) {
  this.off('mouseup', namespace);
}
function offMousefDown(namespace) {
  this.off('mousedown', namespace);
}
function offMousefOver(namespace) {
  this.off('mouseover', namespace);
}
function offMousefOut(namespace) {
  this.off('mouseout', namespace);
}
function offMousefMove(namespace) {
  this.off('mousemove', namespace);
}

function returnEventHandler(handler) {
  return function (event) {
    var mouseTop = event.pageY,
        ///
    mouseLeft = event.pageX,
        ///
    mouseButton = event.which; ///

    handler(mouseTop, mouseLeft, mouseButton);
  };
}
//# sourceMappingURL=data:application/json;base64,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