'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var resize = function () {
  function resize() {
    _classCallCheck(this, resize);
  }

  _createClass(resize, null, [{
    key: 'initialise',
    value: function initialise(element) {
      element.resizeHandlers = [];

      element.onResize = onResize;
      element.offResize = offResize;
    }
  }]);

  return resize;
}();

module.exports = resize;

function onResize(resizeHandler) {
  var resizeHandlers = hasResizeHandlers(this);

  if (!resizeHandlers) {
    appendResizeObject(this);
  }

  addResizeHandler(this, resizeHandler);
}

function offResize(resizeHandler) {
  removeResizeHandler(this, resizeHandler);

  var resizeHandlers = hasResizeHandlers(this);

  if (!resizeHandlers) {
    removeResizeObject(this);
  }
}

function hasResizeHandlers(element) {
  var resizeHandlersLength = element.resizeHandlers.length,
      resizeHandlers = resizeHandlersLength > 0;

  return resizeHandlers;
}

function addResizeHandler(element, resizeHandler) {
  element.resizeHandlers.push(resizeHandler);
}

function removeResizeHandler(element, resizeHandler) {
  var index = element.resizeHandlers.indexOf(resizeHandler); ///

  if (index > -1) {
    var deleteCount = 1;

    element.resizeHandlers.splice(index, deleteCount);
  }
}

function appendResizeObject(element) {
  var resizeObject = document.createElement('object'),
      domElement = element.$element[0],
      ///
  style = ' display: block; \n                  position: absolute; \n                  top: 0; \n                  left: 0; \n                  height: 100%; \n                  width: 100%; \n                  overflow: hidden; \n                  pointer-events: none; \n                  z-index: -1;';

  resizeObject.setAttribute('style', style);
  resizeObject.data = 'about:blank';
  resizeObject.type = 'text/html';

  domElement.__resizeObject__ = resizeObject;

  resizeObject.onload = function () {
    resizeObjectLoadHandler(resizeObject, element);
  };

  domElement.appendChild(resizeObject);
}

function removeResizeObject(element) {
  var domElement = element.$element[0],
      ///
  resizeObject = domElement.__resizeObject__,
      objectWindow = resizeObject.contentDocument.defaultView; ///

  objectWindow.removeEventListener('resize', resizeListener);

  domElement.removeChild(resizeObject);
}

function resizeObjectLoadHandler(resizeObject, element) {
  var resizeObjectWindow = resizeObject.contentDocument.defaultView; ///

  resizeObjectWindow.addEventListener('resize', function () {
    resizeListener(element);
  });
}

function resizeListener(element) {
  var width = element.getWidth(),
      height = element.getHeight();

  element.resizeHandlers.forEach(function (resizeHandler) {
    resizeHandler(width, height);
  });
}
//# sourceMappingURL=data:application/json;base64,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