'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var InputElement = require('../inputElement');

var Checkbox = function (_InputElement) {
  _inherits(Checkbox, _InputElement);

  function Checkbox(selector, changeHandler) {
    _classCallCheck(this, Checkbox);

    var _this = _possibleConstructorReturn(this, (Checkbox.__proto__ || Object.getPrototypeOf(Checkbox)).call(this, selector));

    if (changeHandler) {
      _this.onChange(changeHandler);
    }
    return _this;
  }

  _createClass(Checkbox, [{
    key: 'clone',
    value: function clone(changeHandler) {
      return Checkbox.clone(this, changeHandler);
    }
  }, {
    key: 'onChange',
    value: function onChange(handler) {
      var preventDefault = false;

      this.on('click', handler, preventDefault, intermediateChangeHandler.bind(this)); ///
    }
  }, {
    key: 'check',
    value: function check() {
      var checked = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      checked ? this.setAttribute('checked', 'checked') : this.clearAttribute('checked');
    }
  }, {
    key: 'isChecked',
    value: function isChecked() {
      return this.domElement.checked;
    }
  }], [{
    key: 'clone',
    value: function clone(element, changeHandler) {
      return InputElement.clone(Checkbox, element, changeHandler);
    }
  }, {
    key: 'fromHTML',
    value: function fromHTML(html, changeHandler) {
      return InputElement.fromHTML(Checkbox, html, changeHandler);
    }
  }, {
    key: 'fromDOMElement',
    value: function fromDOMElement(domElement, changeHandler) {
      return InputElement.fromDOMElement(Checkbox, domElement, changeHandler);
    }
  }, {
    key: 'fromProperties',
    value: function fromProperties(properties) {
      var html = '<input type="checkbox" />';
      var onChange = properties.onChange;
      var changeHandler = onChange; ///

      return Checkbox.fromHTML(html, changeHandler);
    }
  }]);

  return Checkbox;
}(InputElement);

module.exports = Checkbox;

function intermediateChangeHandler(handler, event) {
  var checked = this.isChecked();

  handler(checked);
}
//# sourceMappingURL=data:application/json;base64,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