'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var InputElement = require('../inputElement');

var Select = function (_InputElement) {
  _inherits(Select, _InputElement);

  function Select(selector, changeHandler) {
    _classCallCheck(this, Select);

    var _this = _possibleConstructorReturn(this, (Select.__proto__ || Object.getPrototypeOf(Select)).call(this, selector));

    if (changeHandler) {
      _this.onChange(changeHandler);
    }
    return _this;
  }

  _createClass(Select, [{
    key: 'clone',
    value: function clone(changeHandler) {
      return Select.clone(this, changeHandler);
    }
  }, {
    key: 'getSelectedOptionValue',
    value: function getSelectedOptionValue() {
      return this.domElement.value;
    } ///

  }, {
    key: 'setSelectedOptionByValue',
    value: function setSelectedOptionByValue(value) {
      this.domElement.value = value;
    } ///

  }, {
    key: 'onChange',
    value: function onChange(handler) {
      var preventDefault = undefined; ///

      this.on('change', handler, preventDefault, intermediateChangeHandler.bind(this));
    }
  }, {
    key: 'offChange',
    value: function offChange(handler) {
      this.off('change', handler);
    }
  }], [{
    key: 'clone',
    value: function clone(element, changeHandler) {
      return InputElement.clone(Select, element, changeHandler);
    }
  }, {
    key: 'fromHTML',
    value: function fromHTML(html, changeHandler) {
      return InputElement.fromHTML(Select, html, changeHandler);
    }
  }, {
    key: 'fromDOMElement',
    value: function fromDOMElement(domElement, changeHandler) {
      return InputElement.fromDOMElement(Select, domElement, changeHandler);
    }
  }, {
    key: 'fromProperties',
    value: function fromProperties(properties) {
      var html = '<select></select>';
      var onChange = properties.onChange;
      var changeHandler = onChange; ///

      return Select.fromHTML(html, changeHandler);
    }
  }]);

  return Select;
}(InputElement);

module.exports = Select;

function intermediateChangeHandler(handler, event) {
  var selectedOptionValue = this.getSelectedOptionValue();

  handler(selectedOptionValue);
}
//# sourceMappingURL=data:application/json;base64,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