'use strict';

function mixin(object, element, Class) {
  var prototype = findPrototype(element, Class),
      names = Object.keys(object); ///

  names.forEach(function (name) {
    var method = object[name];

    prototype[name] = method;
  });
}

module.exports = mixin;

function findPrototype(element, Class) {
  var elements = [];

  findElements(element, Class, elements);

  var lastElement = last(elements),
      prototype = Object.getPrototypeOf(lastElement);

  return prototype;
}

function findElements(element, Class, elements) {
  if (element instanceof Class) {
    elements.push(element);

    element = Object.getPrototypeOf(element); ///

    findElements(element, Class, elements);
  }
}

function last(array) {
  return array[array.length - 1];
}
//# sourceMappingURL=data:application/json;base64,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