'use strict';

function onClick(handler, preventDefault) {
  var intermediateHandler = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : topLeftButtonIntermediateHandler;
  this.on('click', handler, preventDefault, intermediateHandler);
}

function offClick(handler) {
  this.off('click', handler);
}

var click = {
  onClick: onClick,
  offClick: offClick
};

module.exports = click;

function topLeftButtonIntermediateHandler(handler, event) {
  var mouseTop = event.pageY,
      ///
  mouseLeft = event.pageX,
      ///
  mouseButton = event.button; ///

  handler(mouseTop, mouseLeft, mouseButton);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2VzNi9taXhpbi9jbGljay5qcyJdLCJuYW1lcyI6WyJvbkNsaWNrIiwiaGFuZGxlciIsInByZXZlbnREZWZhdWx0IiwiaW50ZXJtZWRpYXRlSGFuZGxlciIsInRvcExlZnRCdXR0b25JbnRlcm1lZGlhdGVIYW5kbGVyIiwib24iLCJvZmZDbGljayIsIm9mZiIsImNsaWNrIiwibW9kdWxlIiwiZXhwb3J0cyIsImV2ZW50IiwibW91c2VUb3AiLCJwYWdlWSIsIm1vdXNlTGVmdCIsInBhZ2VYIiwibW91c2VCdXR0b24iLCJidXR0b24iXSwibWFwcGluZ3MiOiJBQUFBOztBQUVBLFNBQVNBLE9BQVQsQ0FBaUJDLE9BQWpCLEVBQTBCQyxjQUExQixFQUFrRztBQUFBLE1BQXhEQyxtQkFBd0QsdUVBQWxDQyxnQ0FBa0M7QUFBRSxPQUFLQyxFQUFMLENBQVEsT0FBUixFQUFpQkosT0FBakIsRUFBMEJDLGNBQTFCLEVBQTBDQyxtQkFBMUM7QUFBaUU7O0FBRXJLLFNBQVNHLFFBQVQsQ0FBa0JMLE9BQWxCLEVBQTJCO0FBQUUsT0FBS00sR0FBTCxDQUFTLE9BQVQsRUFBa0JOLE9BQWxCO0FBQTZCOztBQUUxRCxJQUFNTyxRQUFRO0FBQ1pSLFdBQVNBLE9BREc7QUFFWk0sWUFBVUE7QUFGRSxDQUFkOztBQUtBRyxPQUFPQyxPQUFQLEdBQWlCRixLQUFqQjs7QUFFQSxTQUFTSixnQ0FBVCxDQUEwQ0gsT0FBMUMsRUFBbURVLEtBQW5ELEVBQTBEO0FBQ3hELE1BQU1DLFdBQVdELE1BQU1FLEtBQXZCO0FBQUEsTUFBK0I7QUFDekJDLGNBQVlILE1BQU1JLEtBRHhCO0FBQUEsTUFDK0I7QUFDekJDLGdCQUFjTCxNQUFNTSxNQUYxQixDQUR3RCxDQUd0Qjs7QUFFbENoQixVQUFRVyxRQUFSLEVBQWtCRSxTQUFsQixFQUE2QkUsV0FBN0I7QUFDRCIsImZpbGUiOiJjbGljay5qcyIsInNvdXJjZXNDb250ZW50IjpbIid1c2Ugc3RyaWN0JztcblxuZnVuY3Rpb24gb25DbGljayhoYW5kbGVyLCBwcmV2ZW50RGVmYXVsdCwgaW50ZXJtZWRpYXRlSGFuZGxlciA9IHRvcExlZnRCdXR0b25JbnRlcm1lZGlhdGVIYW5kbGVyKSB7IHRoaXMub24oJ2NsaWNrJywgaGFuZGxlciwgcHJldmVudERlZmF1bHQsIGludGVybWVkaWF0ZUhhbmRsZXIpOyB9XG5cbmZ1bmN0aW9uIG9mZkNsaWNrKGhhbmRsZXIpIHsgdGhpcy5vZmYoJ2NsaWNrJywgaGFuZGxlcik7IH1cblxuY29uc3QgY2xpY2sgPSB7XG4gIG9uQ2xpY2s6IG9uQ2xpY2ssXG4gIG9mZkNsaWNrOiBvZmZDbGlja1xufTtcblxubW9kdWxlLmV4cG9ydHMgPSBjbGljaztcblxuZnVuY3Rpb24gdG9wTGVmdEJ1dHRvbkludGVybWVkaWF0ZUhhbmRsZXIoaGFuZGxlciwgZXZlbnQpIHtcbiAgY29uc3QgbW91c2VUb3AgPSBldmVudC5wYWdlWSwgIC8vL1xuICAgICAgICBtb3VzZUxlZnQgPSBldmVudC5wYWdlWCwgLy8vXG4gICAgICAgIG1vdXNlQnV0dG9uID0gZXZlbnQuYnV0dG9uOyAvLy9cblxuICBoYW5kbGVyKG1vdXNlVG9wLCBtb3VzZUxlZnQsIG1vdXNlQnV0dG9uKTtcbn1cbiJdfQ==