'use strict';

function on(eventTypes, handler) {
  var preventDefault = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  var intermediateHandler = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function (handler, event) {
    handler(event);
  };

  eventTypes = eventTypes.split(' '); ///

  eventTypes.forEach(function (eventType) {
    var addEventListener = this.addHandler(eventType, handler, preventDefault, intermediateHandler);

    if (addEventListener) {
      this.domElement.addEventListener(eventType, eventListener.bind(this));
    }
  }.bind(this));
}

function off(eventTypes, handler) {
  eventTypes = eventTypes.split(' '); ///

  eventTypes.forEach(function (eventType) {
    var removeEventListener = this.removeHandler(eventType, handler);

    if (removeEventListener) {
      this.domElement.removeEventListener(eventType, eventListener.bind(this));
    }
  }.bind(this));
}

function addHandler(eventType, handler, preventDefault, intermediateHandler) {
  if (preventDefault !== undefined) {
    handler.preventDefault = preventDefault;
  }

  if (intermediateHandler !== undefined) {
    handler.intermediateHandler = intermediateHandler;
  }

  var addEventListener = false,
      handlers = this.handlersMap[eventType];

  if (handlers === undefined) {
    handlers = [];

    this.handlersMap[eventType] = handlers;

    addEventListener = true;
  }

  handlers.push(handler);

  return addEventListener;
}

function removeHandler(eventType, handler) {
  var removeEventListener = false,
      handlers = this.handlersMap[eventType];

  if (handlers.length === 0) {
    delete this.handlersMap[eventType];

    removeEventListener = true;
  } else {
    var index = handlers.indexOf(handler);

    if (index > -1) {
      var deleteCount = 1;

      handlers.splice(index, deleteCount);
    }
  }

  return removeEventListener;
}

var event = {
  on: on,
  off: off,
  addHandler: addHandler,
  removeHandler: removeHandler
};

module.exports = event;

function eventListener(event) {
  var eventType = event.eventType,
      handlers = this.handlersMap[eventType];

  handlers.forEach(function (handler) {
    handler.intermediateHandler(handler, event);

    if (handler.preventDefault) {
      event.preventDefault();
    }
  });
}
//# sourceMappingURL=data:application/json;base64,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