'use strict';

function onMouseUp(handler, preventDefault) {
  var intermediateHandler = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : topLeftButtonIntermediateHandler;
  this.on('mouseup', handler, preventDefault, intermediateHandler);
}

function offMouseUp(handler) {
  this.off('mouseup', handler);
}

function onMouseDown(handler, preventDefault) {
  var intermediateHandler = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : topLeftButtonIntermediateHandler;
  this.on('mousedown', handler, preventDefault, intermediateHandler);
}

function offMouseDown(handler) {
  this.off('mousedown', handler);
}

function onMouseOver(handler, preventDefault) {
  var intermediateHandler = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : topLeftIntermediateHandler;
  this.on('mouseover', handler, preventDefault, intermediateHandler);
}

function offMouseOver(handler) {
  this.off('mouseover', handler);
}

function onMouseOut(handler, preventDefault) {
  var intermediateHandler = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : topLeftIntermediateHandler;
  this.on('mouseout', handler, preventDefault, intermediateHandler);
}

function offMouseOut(handler) {
  this.off('mouseout', handler);
}

function onMouseMove(handler, preventDefault) {
  var intermediateHandler = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : topLeftIntermediateHandler;
  this.on('mousemove', handler, preventDefault, intermediateHandler);
}

function offMouseMove(handler) {
  this.off('mousemove', handler);
}

var mouse = {
  onMouseUp: onMouseUp,
  offMouseUp: offMouseUp,
  onMouseDown: onMouseDown,
  offMouseDown: offMouseDown,
  onMouseOver: onMouseOver,
  offMouseOver: offMouseOver,
  onMouseOut: onMouseOut,
  offMouseOut: offMouseOut,
  onMouseMove: onMouseMove,
  offMouseMove: offMouseMove
};

module.exports = mouse;

function topLeftIntermediateHandler(handler, event) {
  var mouseTop = event.pageY,
      ///
  mouseLeft = event.pageX; ///

  handler(mouseTop, mouseLeft);
}

function topLeftButtonIntermediateHandler(handler, event) {
  var mouseTop = event.pageY,
      ///
  mouseLeft = event.pageX,
      ///
  mouseButton = event.button; ///

  handler(mouseTop, mouseLeft, mouseButton);
}
//# sourceMappingURL=data:application/json;base64,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