'use strict';

function onResize(handler) {
  var eventType = 'resize',
      addEventListener = this.addHandler(eventType, handler);

  if (addEventListener) {
    appendResizeObject(this);
  }
}

function offResize(handler) {
  var eventType = 'resize',
      removeEventListener = this.removeHandler(eventType, handler);

  if (removeEventListener) {
    removeResizeObject(this);
  }
}

var resize = {
  onResize: onResize,
  offResize: offResize
};

module.exports = resize;

function appendResizeObject(element) {
  var resizeObject = document.createElement('object'),
      domElement = element.domElement,
      style = ' display: block; \n                  position: absolute; \n                  top: 0; \n                  left: 0; \n                  height: 100%; \n                  width: 100%; \n                  overflow: hidden; \n                  pointer-events: none; \n                  z-index: -1;';

  resizeObject.setAttribute('style', style);
  resizeObject.data = 'about:blank';
  resizeObject.type = 'text/html';

  element.__resizeObject__ = resizeObject;

  resizeObject.onload = function () {
    resizeObjectLoadHandler(element);
  };

  domElement.appendChild(resizeObject);
}

function removeResizeObject(element) {
  var domElement = element.domElement,
      resizeObject = element.__resizeObject__,
      objectWindow = resizeObject.contentDocument.defaultView; ///

  objectWindow.removeEventListener('resize', resizeListener);

  domElement.removeChild(resizeObject);
}

function resizeObjectLoadHandler(element) {
  var resizeObject = element.__resizeObject__,
      resizeObjectWindow = resizeObject.contentDocument.defaultView; ///

  resizeObjectWindow.addEventListener('resize', function () {
    eventListener(element);
  });
}

function eventListener(element) {
  var width = element.getWidth(),
      height = element.getHeight(),
      handlers = element.handlersMap['resize'];

  handlers.forEach(function (handler) {
    handler(width, height);
  });
}
//# sourceMappingURL=data:application/json;base64,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