export default "@export ecgl.sdfSprite.vertex\r\n\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\nuniform float elapsedTime : 0;\r\n\r\nattribute vec3 position : POSITION;\r\n\r\n#ifdef VERTEX_SIZE\r\nattribute float size;\r\n#else\r\nuniform float u_Size;\r\n#endif\r\n\r\n#ifdef VERTEX_COLOR\r\nattribute vec4 a_FillColor: COLOR;\r\nvarying vec4 v_Color;\r\n#endif\r\n\r\n#ifdef VERTEX_ANIMATION\r\nattribute vec3 prevPosition;\r\nattribute float prevSize;\r\nuniform float percent : 1.0;\r\n#endif\r\n\r\n\r\n#ifdef POSITIONTEXTURE_ENABLED\r\nuniform sampler2D positionTexture;\r\n#endif\r\n\r\nvarying float v_Size;\r\n\r\nvoid main()\r\n{\r\n\r\n#ifdef POSITIONTEXTURE_ENABLED\r\n // Only 2d position texture supported\r\n gl_Position = worldViewProjection * vec4(texture2D(positionTexture, position.xy).xy, -10.0, 1.0);\r\n#else\r\n\r\n #ifdef VERTEX_ANIMATION\r\n vec3 pos = mix(prevPosition, position, percent);\r\n #else\r\n vec3 pos = position;\r\n #endif\r\n gl_Position = worldViewProjection * vec4(pos, 1.0);\r\n#endif\r\n\r\n#ifdef VERTEX_SIZE\r\n#ifdef VERTEX_ANIMATION\r\n v_Size = mix(prevSize, size, percent);\r\n#else\r\n v_Size = size;\r\n#endif\r\n#else\r\n v_Size = u_Size;\r\n#endif\r\n\r\n#ifdef VERTEX_COLOR\r\n v_Color = a_FillColor;\r\n // v_StrokeColor = a_StrokeColor;\r\n#endif\r\n\r\n gl_PointSize = v_Size;\r\n}\r\n\r\n@end\r\n\r\n@export ecgl.sdfSprite.fragment\r\n\r\nuniform vec4 color: [1, 1, 1, 1];\r\nuniform vec4 strokeColor: [1, 1, 1, 1];\r\nuniform float smoothing: 0.07;\r\n\r\nuniform float lineWidth: 0.0;\r\n\r\n#ifdef VERTEX_COLOR\r\nvarying vec4 v_Color;\r\n// varying vec4 v_StrokeColor;\r\n#endif\r\n\r\nvarying float v_Size;\r\n\r\nuniform sampler2D sprite;\r\n\r\n@import clay.util.srgb\r\n\r\nvoid main()\r\n{\r\n gl_FragColor = color;\r\n\r\n vec4 _strokeColor = strokeColor;\r\n\r\n#ifdef VERTEX_COLOR\r\n gl_FragColor *= v_Color;\r\n // TODO\r\n // _strokeColor *= v_StrokeColor;\r\n#endif\r\n\r\n#ifdef SPRITE_ENABLED\r\n float d = texture2D(sprite, gl_PointCoord).r;\r\n // Antialias\r\n gl_FragColor.a *= smoothstep(0.5 - smoothing, 0.5 + smoothing, d);\r\n\r\n if (lineWidth > 0.0) {\r\n // TODO SCREEN SPACE OUTLINE\r\n float sLineWidth = lineWidth / 2.0;\r\n\r\n float outlineMaxValue0 = 0.5 + sLineWidth;\r\n float outlineMaxValue1 = 0.5 + sLineWidth + smoothing;\r\n float outlineMinValue0 = 0.5 - sLineWidth - smoothing;\r\n float outlineMinValue1 = 0.5 - sLineWidth;\r\n\r\n // FIXME Aliasing\r\n if (d <= outlineMaxValue1 && d >= outlineMinValue0) {\r\n float a = _strokeColor.a;\r\n if (d <= outlineMinValue1) {\r\n a = a * smoothstep(outlineMinValue0, outlineMinValue1, d);\r\n }\r\n else {\r\n a = a * smoothstep(outlineMaxValue1, outlineMaxValue0, d);\r\n }\r\n gl_FragColor.rgb = mix(gl_FragColor.rgb * gl_FragColor.a, _strokeColor.rgb, a);\r\n gl_FragColor.a = gl_FragColor.a * (1.0 - a) + a;\r\n }\r\n }\r\n#endif\r\n\r\n#ifdef SRGB_DECODE\r\n gl_FragColor = sRGBToLinear(gl_FragColor);\r\n#endif\r\n}\r\n@end";