export default "@export ecgl.vfParticle.particle.fragment\r\n\r\nuniform sampler2D particleTexture;\r\nuniform sampler2D spawnTexture;\r\nuniform sampler2D velocityTexture;\r\n\r\nuniform float deltaTime;\r\nuniform float elapsedTime;\r\n\r\nuniform float speedScaling : 1.0;\r\n\r\nuniform vec2 textureSize;\r\nuniform vec4 region : [0, 0, 1, 1];\r\nuniform float firstFrameTime;\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\n// vec2 bilinearFetch(vec2 uv)\r\n// {\r\n// vec2 off = 1.0 / textureSize;\r\n// vec2 sc = (floor(uv * textureSize)) * off;\r\n// vec2 f = fract(uv * textureSize);\r\n// vec2 tl = texture2D(velocityTexture, sc).xy;\r\n// vec2 tr = texture2D(velocityTexture, sc + vec2(off.x, 0)).xy;\r\n// vec2 bl = texture2D(velocityTexture, sc + vec2(0, off.y)).xy;\r\n// vec2 br = texture2D(velocityTexture, sc + off).xy;\r\n// return mix(mix(tl, tr, f.x), mix(bl, br, f.x), f.y);\r\n// }\r\n\r\nvoid main()\r\n{\r\n vec4 p = texture2D(particleTexture, v_Texcoord);\r\n bool spawn = false;\r\n if (p.w <= 0.0) {\r\n p = texture2D(spawnTexture, fract(v_Texcoord + elapsedTime / 10.0));\r\n p.w -= firstFrameTime;\r\n spawn = true;\r\n }\r\n vec2 v = texture2D(velocityTexture, fract(p.xy * region.zw + region.xy)).xy;\r\n // https://blog.mapbox.com/how-i-built-a-wind-map-with-webgl-b63022b5537f\r\n // vec2 v = bilinearFetch(fract(p.xy * region.zw + region.xy));\r\n v = (v - 0.5) * 2.0;\r\n p.z = length(v);\r\n p.xy += v * deltaTime / 10.0 * speedScaling;\r\n p.w -= deltaTime;\r\n\r\n // TODO Not show just spawned particle or crossed particle.\r\n if (spawn || p.xy != fract(p.xy)) {\r\n p.z = 0.0;\r\n }\r\n // Make the particle surface seamless\r\n p.xy = fract(p.xy);\r\n\r\n gl_FragColor = p;\r\n}\r\n@end\r\n\r\n@export ecgl.vfParticle.renderPoints.vertex\r\n\r\n#define PI 3.1415926\r\n\r\nattribute vec2 texcoord : TEXCOORD_0;\r\n\r\nuniform sampler2D particleTexture;\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\n\r\nuniform float size : 1.0;\r\n\r\nvarying float v_Mag;\r\nvarying vec2 v_Uv;\r\n\r\nvoid main()\r\n{\r\n vec4 p = texture2D(particleTexture, texcoord);\r\n\r\n // PENDING If ignore 0 length vector\r\n if (p.w > 0.0 && p.z > 1e-5) {\r\n gl_Position = worldViewProjection * vec4(p.xy * 2.0 - 1.0, 0.0, 1.0);\r\n }\r\n else {\r\n gl_Position = vec4(100000.0, 100000.0, 100000.0, 1.0);\r\n }\r\n\r\n v_Mag = p.z;\r\n v_Uv = p.xy;\r\n\r\n gl_PointSize = size;\r\n}\r\n\r\n@end\r\n\r\n@export ecgl.vfParticle.renderPoints.fragment\r\n\r\nuniform vec4 color : [1.0, 1.0, 1.0, 1.0];\r\nuniform sampler2D gradientTexture;\r\nuniform sampler2D colorTexture;\r\nuniform sampler2D spriteTexture;\r\n\r\nvarying float v_Mag;\r\nvarying vec2 v_Uv;\r\n\r\nvoid main()\r\n{\r\n gl_FragColor = color;\r\n#ifdef SPRITETEXTURE_ENABLED\r\n gl_FragColor *= texture2D(spriteTexture, gl_PointCoord);\r\n if (color.a == 0.0) {\r\n discard;\r\n }\r\n#endif\r\n#ifdef GRADIENTTEXTURE_ENABLED\r\n gl_FragColor *= texture2D(gradientTexture, vec2(v_Mag, 0.5));\r\n#endif\r\n#ifdef COLORTEXTURE_ENABLED\r\n gl_FragColor *= texture2D(colorTexture, v_Uv);\r\n#endif\r\n}\r\n\r\n@end\r\n\r\n@export ecgl.vfParticle.renderLines.vertex\r\n\r\n#define PI 3.1415926\r\n\r\nattribute vec3 position : POSITION;\r\n\r\nuniform sampler2D particleTexture;\r\nuniform sampler2D prevParticleTexture;\r\n\r\nuniform float size : 1.0;\r\nuniform vec4 vp: VIEWPORT;\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\n\r\nvarying float v_Mag;\r\nvarying vec2 v_Uv;\r\n\r\n@import clay.util.rand\r\n\r\nvoid main()\r\n{\r\n vec4 p = texture2D(particleTexture, position.xy);\r\n vec4 p2 = texture2D(prevParticleTexture, position.xy);\r\n\r\n p.xy = p.xy * 2.0 - 1.0;\r\n p2.xy = p2.xy * 2.0 - 1.0;\r\n\r\n // PENDING If ignore 0 length vector\r\n if (p.w > 0.0 && p.z > 1e-5) {\r\n vec2 dir = normalize(p.xy - p2.xy);\r\n vec2 norm = vec2(dir.y / vp.z, -dir.x / vp.w) * sign(position.z) * size;\r\n if (abs(position.z) == 2.0) {\r\n gl_Position = vec4(p.xy + norm, 0.0, 1.0);\r\n v_Uv = p.xy;\r\n v_Mag = p.z;\r\n }\r\n else {\r\n gl_Position = vec4(p2.xy + norm, 0.0, 1.0);\r\n v_Mag = p2.z;\r\n v_Uv = p2.xy;\r\n }\r\n gl_Position = worldViewProjection * gl_Position;\r\n }\r\n else {\r\n gl_Position = vec4(100000.0, 100000.0, 100000.0, 1.0);\r\n }\r\n}\r\n\r\n@end\r\n\r\n@export ecgl.vfParticle.renderLines.fragment\r\n\r\nuniform vec4 color : [1.0, 1.0, 1.0, 1.0];\r\nuniform sampler2D gradientTexture;\r\nuniform sampler2D colorTexture;\r\n\r\nvarying float v_Mag;\r\nvarying vec2 v_Uv;\r\n\r\nvoid main()\r\n{\r\n gl_FragColor = color;\r\n // gl_FragColor = mix(vec4(1.0,0.0,0.0,1.0), vec4(0.0,0.0,1.0,1.0), 1.0 - v_Mag);\r\n#ifdef GRADIENTTEXTURE_ENABLED\r\n gl_FragColor *= texture2D(gradientTexture, vec2(v_Mag, 0.5));\r\n#endif\r\n#ifdef COLORTEXTURE_ENABLED\r\n gl_FragColor *= texture2D(colorTexture, v_Uv);\r\n#endif\r\n}\r\n\r\n@end\r\n";