export default "@export ecgl.forceAtlas2.updateNodeRepulsion\r\n\r\n#define NODE_COUNT 0\r\n\r\nuniform sampler2D positionTex;\r\n\r\nuniform vec2 textureSize;\r\nuniform float gravity;\r\nuniform float scaling;\r\nuniform vec2 gravityCenter;\r\n\r\nuniform bool strongGravityMode;\r\nuniform bool preventOverlap;\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\nvoid main() {\r\n\r\n vec4 n0 = texture2D(positionTex, v_Texcoord);\r\n\r\n vec2 force = vec2(0.0);\r\n for (int i = 0; i < NODE_COUNT; i++) {\r\n vec2 uv = vec2(\r\n mod(float(i), textureSize.x) / (textureSize.x - 1.0),\r\n floor(float(i) / textureSize.x) / (textureSize.y - 1.0)\r\n );\r\n vec4 n1 = texture2D(positionTex, uv);\r\n\r\n vec2 dir = n0.xy - n1.xy;\r\n float d2 = dot(dir, dir);\r\n\r\n if (d2 > 0.0) {\r\n float factor = 0.0;\r\n if (preventOverlap) {\r\n float d = sqrt(d2);\r\n d = d - n0.w - n1.w;\r\n if (d > 0.0) {\r\n factor = scaling * n0.z * n1.z / (d * d);\r\n }\r\n else if (d < 0.0) {\r\n // A stronger repulsion if overlap\r\n factor = scaling * 100.0 * n0.z * n1.z;\r\n }\r\n }\r\n else {\r\n // Divide factor by an extra `d` to normalize the `v`\r\n factor = scaling * n0.z * n1.z / d2;\r\n }\r\n force += dir * factor;\r\n }\r\n }\r\n\r\n // Gravity\r\n vec2 dir = gravityCenter - n0.xy;\r\n float d = 1.0;\r\n if (!strongGravityMode) {\r\n d = length(dir);\r\n }\r\n\r\n force += dir * n0.z * gravity / (d + 1.0);\r\n\r\n gl_FragColor = vec4(force, 0.0, 1.0);\r\n}\r\n@end\r\n\r\n@export ecgl.forceAtlas2.updateEdgeAttraction.vertex\r\n\r\nattribute vec2 node1;\r\nattribute vec2 node2;\r\nattribute float weight;\r\n\r\nuniform sampler2D positionTex;\r\nuniform float edgeWeightInfluence;\r\nuniform bool preventOverlap;\r\nuniform bool linLogMode;\r\n\r\nuniform vec2 windowSize: WINDOW_SIZE;\r\n\r\nvarying vec2 v_Force;\r\n\r\nvoid main() {\r\n\r\n vec4 n0 = texture2D(positionTex, node1);\r\n vec4 n1 = texture2D(positionTex, node2);\r\n\r\n vec2 dir = n1.xy - n0.xy;\r\n float d = length(dir);\r\n float w;\r\n if (edgeWeightInfluence == 0.0) {\r\n w = 1.0;\r\n }\r\n else if (edgeWeightInfluence == 1.0) {\r\n w = weight;\r\n }\r\n else {\r\n w = pow(weight, edgeWeightInfluence);\r\n }\r\n // Add 0.5 offset.\r\n // PENDING.\r\n vec2 offset = vec2(1.0 / windowSize.x, 1.0 / windowSize.y);\r\n vec2 scale = vec2((windowSize.x - 1.0) / windowSize.x, (windowSize.y - 1.0) / windowSize.y);\r\n vec2 pos = node1 * scale * 2.0 - 1.0;\r\n gl_Position = vec4(pos + offset, 0.0, 1.0);\r\n gl_PointSize = 1.0;\r\n\r\n float factor;\r\n if (preventOverlap) {\r\n d = d - n1.w - n0.w;\r\n }\r\n if (d <= 0.0) {\r\n v_Force = vec2(0.0);\r\n return;\r\n }\r\n\r\n if (linLogMode) {\r\n // Divide factor by an extra `d` to normalize the `v`\r\n factor = w * log(d) / d;\r\n }\r\n else {\r\n factor = w;\r\n }\r\n v_Force = dir * factor;\r\n}\r\n@end\r\n\r\n@export ecgl.forceAtlas2.updateEdgeAttraction.fragment\r\n\r\nvarying vec2 v_Force;\r\n\r\nvoid main() {\r\n gl_FragColor = vec4(v_Force, 0.0, 0.0);\r\n}\r\n@end\r\n\r\n@export ecgl.forceAtlas2.calcWeightedSum.vertex\r\n\r\nattribute vec2 node;\r\n\r\nvarying vec2 v_NodeUv;\r\n\r\nvoid main() {\r\n\r\n v_NodeUv = node;\r\n gl_Position = vec4(0.0, 0.0, 0.0, 1.0);\r\n gl_PointSize = 1.0;\r\n}\r\n@end\r\n\r\n@export ecgl.forceAtlas2.calcWeightedSum.fragment\r\n\r\nvarying vec2 v_NodeUv;\r\n\r\nuniform sampler2D positionTex;\r\nuniform sampler2D forceTex;\r\nuniform sampler2D forcePrevTex;\r\n\r\nvoid main() {\r\n vec2 force = texture2D(forceTex, v_NodeUv).rg;\r\n vec2 forcePrev = texture2D(forcePrevTex, v_NodeUv).rg;\r\n\r\n float mass = texture2D(positionTex, v_NodeUv).z;\r\n float swing = length(force - forcePrev) * mass;\r\n float traction = length(force + forcePrev) * 0.5 * mass;\r\n\r\n gl_FragColor = vec4(swing, traction, 0.0, 0.0);\r\n}\r\n@end\r\n\r\n@export ecgl.forceAtlas2.calcGlobalSpeed\r\n\r\nuniform sampler2D globalSpeedPrevTex;\r\nuniform sampler2D weightedSumTex;\r\nuniform float jitterTolerence;\r\n\r\nvoid main() {\r\n vec2 weightedSum = texture2D(weightedSumTex, vec2(0.5)).xy;\r\n float prevGlobalSpeed = texture2D(globalSpeedPrevTex, vec2(0.5)).x;\r\n float globalSpeed = jitterTolerence * jitterTolerence\r\n // traction / swing\r\n * weightedSum.y / weightedSum.x;\r\n if (prevGlobalSpeed > 0.0) {\r\n globalSpeed = min(globalSpeed / prevGlobalSpeed, 1.5) * prevGlobalSpeed;\r\n }\r\n gl_FragColor = vec4(globalSpeed, 0.0, 0.0, 1.0);\r\n}\r\n@end\r\n\r\n@export ecgl.forceAtlas2.updatePosition\r\n\r\nuniform sampler2D forceTex;\r\nuniform sampler2D forcePrevTex;\r\nuniform sampler2D positionTex;\r\nuniform sampler2D globalSpeedTex;\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\nvoid main() {\r\n vec2 force = texture2D(forceTex, v_Texcoord).xy;\r\n vec2 forcePrev = texture2D(forcePrevTex, v_Texcoord).xy;\r\n vec4 node = texture2D(positionTex, v_Texcoord);\r\n\r\n float globalSpeed = texture2D(globalSpeedTex, vec2(0.5)).r;\r\n float swing = length(force - forcePrev);\r\n float speed = 0.1 * globalSpeed / (0.1 + globalSpeed * sqrt(swing));\r\n\r\n // Additional constraint to prevent local speed gets too high\r\n float df = length(force);\r\n if (df > 0.0) {\r\n speed = min(df * speed, 10.0) / df;\r\n\r\n gl_FragColor = vec4(node.xy + speed * force, node.zw);\r\n }\r\n else {\r\n gl_FragColor = node;\r\n }\r\n}\r\n@end\r\n\r\n// For edge draw\r\n@export ecgl.forceAtlas2.edges.vertex\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\n\r\nattribute vec2 node;\r\nattribute vec4 a_Color : COLOR;\r\nvarying vec4 v_Color;\r\n\r\nuniform sampler2D positionTex;\r\n\r\nvoid main()\r\n{\r\n gl_Position = worldViewProjection * vec4(\r\n texture2D(positionTex, node).xy, -10.0, 1.0\r\n );\r\n v_Color = a_Color;\r\n}\r\n@end\r\n\r\n@export ecgl.forceAtlas2.edges.fragment\r\nuniform vec4 color : [1.0, 1.0, 1.0, 1.0];\r\nvarying vec4 v_Color;\r\nvoid main() {\r\n gl_FragColor = color * v_Color;\r\n}\r\n@end";