export default "@export ecgl.edge\r\n// http://williamchyr.com/2014/03/development-update-edge-detection/\r\n// http://williamchyr.com/2014/05/revisiting-edge-detection/\r\n// http://williamchyr.com/2015/08/edge-detection-shader-deep-dive-part-1-even-or-thinner-edges/\r\n// http://www.thomaseichhorn.de/npr-sketch-shader-vvvv/\r\n\r\nuniform sampler2D texture;\r\n\r\nuniform sampler2D normalTexture;\r\nuniform sampler2D depthTexture;\r\n\r\nuniform mat4 projectionInv;\r\n\r\nuniform vec2 textureSize;\r\n\r\nuniform vec4 edgeColor: [0,0,0,0.8];\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\nvec3 packColor(vec2 coord) {\r\n float z = texture2D(depthTexture, coord).r * 2.0 - 1.0;\r\n vec4 p = vec4(v_Texcoord * 2.0 - 1.0, z, 1.0);\r\n vec4 p4 = projectionInv * p;\r\n\r\n return vec3(\r\n texture2D(normalTexture, coord).rg,\r\n -p4.z / p4.w / 5.0\r\n );\r\n}\r\n\r\nvoid main() {\r\n vec2 cc = v_Texcoord;\r\n // center\r\n vec3 center = packColor(cc);\r\n\r\n // PENDING Fade out in 100 - 500\r\n float size = clamp(1.0 - (center.z - 10.0) / 100.0, 0.0, 1.0) * 0.5;\r\n float dx = size / textureSize.x;\r\n float dy = size / textureSize.y;\r\n\r\n vec2 coord;\r\n // top left\r\n vec3 topLeft = packColor(cc+vec2(-dx, -dy));\r\n // top\r\n vec3 top = packColor(cc+vec2(0.0, -dy));\r\n // top right\r\n vec3 topRight = packColor(cc+vec2(dx, -dy));\r\n // left\r\n vec3 left = packColor(cc+vec2(-dx, 0.0));\r\n // right\r\n vec3 right = packColor(cc+vec2(dx, 0.0));\r\n // bottom left\r\n vec3 bottomLeft = packColor(cc+vec2(-dx, dy));\r\n // bottom\r\n vec3 bottom = packColor(cc+vec2(0.0, dy));\r\n // bottom right\r\n vec3 bottomRight = packColor(cc+vec2(dx, dy));\r\n\r\n vec3 v = -topLeft-2.0*top-topRight+bottomLeft+2.0*bottom+bottomRight;\r\n vec3 h = -bottomLeft-2.0*left-topLeft+bottomRight+2.0*right+topRight;\r\n\r\n float edge = sqrt(dot(h, h) + dot(v, v));\r\n\r\n edge = smoothstep(0.8, 1.0, edge);\r\n\r\n gl_FragColor = mix(texture2D(texture, v_Texcoord), vec4(edgeColor.rgb, 1.0), edgeColor.a * edge);\r\n}\r\n@end";