export default "@export ecgl.color.vertex\r\n\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\n\r\n@import ecgl.common.uv.header\r\n\r\nattribute vec2 texcoord : TEXCOORD_0;\r\nattribute vec3 position: POSITION;\r\n\r\n@import ecgl.common.wireframe.vertexHeader\r\n\r\n#ifdef VERTEX_COLOR\r\nattribute vec4 a_Color : COLOR;\r\nvarying vec4 v_Color;\r\n#endif\r\n\r\n#ifdef VERTEX_ANIMATION\r\nattribute vec3 prevPosition;\r\nuniform float percent : 1.0;\r\n#endif\r\n\r\n#ifdef ATMOSPHERE_ENABLED\r\nattribute vec3 normal: NORMAL;\r\nuniform mat4 worldInverseTranspose : WORLDINVERSETRANSPOSE;\r\nvarying vec3 v_Normal;\r\n#endif\r\n\r\nvoid main()\r\n{\r\n#ifdef VERTEX_ANIMATION\r\n vec3 pos = mix(prevPosition, position, percent);\r\n#else\r\n vec3 pos = position;\r\n#endif\r\n\r\n gl_Position = worldViewProjection * vec4(pos, 1.0);\r\n\r\n @import ecgl.common.uv.main\r\n\r\n#ifdef VERTEX_COLOR\r\n v_Color = a_Color;\r\n#endif\r\n\r\n#ifdef ATMOSPHERE_ENABLED\r\n v_Normal = normalize((worldInverseTranspose * vec4(normal, 0.0)).xyz);\r\n#endif\r\n\r\n @import ecgl.common.wireframe.vertexMain\r\n\r\n}\r\n\r\n@end\r\n\r\n@export ecgl.color.fragment\r\n\r\n#define LAYER_DIFFUSEMAP_COUNT 0\r\n#define LAYER_EMISSIVEMAP_COUNT 0\r\n\r\nuniform sampler2D diffuseMap;\r\nuniform sampler2D detailMap;\r\n\r\nuniform vec4 color : [1.0, 1.0, 1.0, 1.0];\r\n\r\n#ifdef ATMOSPHERE_ENABLED\r\nuniform mat4 viewTranspose: VIEWTRANSPOSE;\r\nuniform vec3 glowColor;\r\nuniform float glowPower;\r\nvarying vec3 v_Normal;\r\n#endif\r\n\r\n#ifdef VERTEX_COLOR\r\nvarying vec4 v_Color;\r\n#endif\r\n\r\n@import ecgl.common.layers.header\r\n\r\n@import ecgl.common.uv.fragmentHeader\r\n\r\n@import ecgl.common.wireframe.fragmentHeader\r\n\r\n@import clay.util.srgb\r\n\r\nvoid main()\r\n{\r\n#ifdef SRGB_DECODE\r\n gl_FragColor = sRGBToLinear(color);\r\n#else\r\n gl_FragColor = color;\r\n#endif\r\n\r\n#ifdef VERTEX_COLOR\r\n gl_FragColor *= v_Color;\r\n#endif\r\n\r\n @import ecgl.common.albedo.main\r\n\r\n @import ecgl.common.diffuseLayer.main\r\n\r\n gl_FragColor *= albedoTexel;\r\n\r\n#ifdef ATMOSPHERE_ENABLED\r\n float atmoIntensity = pow(1.0 - dot(v_Normal, (viewTranspose * vec4(0.0, 0.0, 1.0, 0.0)).xyz), glowPower);\r\n gl_FragColor.rgb += glowColor * atmoIntensity;\r\n#endif\r\n\r\n @import ecgl.common.emissiveLayer.main\r\n\r\n @import ecgl.common.wireframe.fragmentMain\r\n\r\n}\r\n@end";