export default "@export ecgl.hatching.vertex\r\n\r\n@import ecgl.realistic.vertex\r\n\r\n@end\r\n\r\n\r\n@export ecgl.hatching.fragment\r\n\r\n#define NORMAL_UP_AXIS 1\r\n#define NORMAL_FRONT_AXIS 2\r\n\r\n@import ecgl.common.uv.fragmentHeader\r\n\r\nvarying vec3 v_Normal;\r\nvarying vec3 v_WorldPosition;\r\n\r\nuniform vec4 color : [0.0, 0.0, 0.0, 1.0];\r\nuniform vec4 paperColor : [1.0, 1.0, 1.0, 1.0];\r\n\r\nuniform mat4 viewInverse : VIEWINVERSE;\r\n\r\n#ifdef AMBIENT_LIGHT_COUNT\r\n@import clay.header.ambient_light\r\n#endif\r\n#ifdef AMBIENT_SH_LIGHT_COUNT\r\n@import clay.header.ambient_sh_light\r\n#endif\r\n\r\n#ifdef DIRECTIONAL_LIGHT_COUNT\r\n@import clay.header.directional_light\r\n#endif\r\n\r\n#ifdef VERTEX_COLOR\r\nvarying vec4 v_Color;\r\n#endif\r\n\r\n\r\n@import ecgl.common.ssaoMap.header\r\n\r\n@import ecgl.common.bumpMap.header\r\n\r\n@import clay.util.srgb\r\n\r\n@import ecgl.common.wireframe.fragmentHeader\r\n\r\n@import clay.plugin.compute_shadow_map\r\n\r\nuniform sampler2D hatch1;\r\nuniform sampler2D hatch2;\r\nuniform sampler2D hatch3;\r\nuniform sampler2D hatch4;\r\nuniform sampler2D hatch5;\r\nuniform sampler2D hatch6;\r\n\r\n// https://github.com/spite/cross-hatching\r\n// http://gfx.cs.princeton.edu/proj/hatching/hatching.pdf\r\nfloat shade(in float tone) {\r\n vec4 c = vec4(1. ,1., 1., 1.);\r\n float step = 1. / 6.;\r\n vec2 uv = v_DetailTexcoord;\r\n if (tone <= step / 2.0) {\r\n c = mix(vec4(0.), texture2D(hatch6, uv), 12. * tone);\r\n }\r\n else if (tone <= step) {\r\n c = mix(texture2D(hatch6, uv), texture2D(hatch5, uv), 6. * tone);\r\n }\r\n if(tone > step && tone <= 2. * step){\r\n c = mix(texture2D(hatch5, uv), texture2D(hatch4, uv) , 6. * (tone - step));\r\n }\r\n if(tone > 2. * step && tone <= 3. * step){\r\n c = mix(texture2D(hatch4, uv), texture2D(hatch3, uv), 6. * (tone - 2. * step));\r\n }\r\n if(tone > 3. * step && tone <= 4. * step){\r\n c = mix(texture2D(hatch3, uv), texture2D(hatch2, uv), 6. * (tone - 3. * step));\r\n }\r\n if(tone > 4. * step && tone <= 5. * step){\r\n c = mix(texture2D(hatch2, uv), texture2D(hatch1, uv), 6. * (tone - 4. * step));\r\n }\r\n if(tone > 5. * step){\r\n c = mix(texture2D(hatch1, uv), vec4(1.), 6. * (tone - 5. * step));\r\n }\r\n\r\n return c.r;\r\n}\r\n\r\nconst vec3 w = vec3(0.2125, 0.7154, 0.0721);\r\n\r\nvoid main()\r\n{\r\n#ifdef SRGB_DECODE\r\n vec4 inkColor = sRGBToLinear(color);\r\n#else\r\n vec4 inkColor = color;\r\n#endif\r\n\r\n#ifdef VERTEX_COLOR\r\n // PENDING\r\n #ifdef SRGB_DECODE\r\n inkColor *= sRGBToLinear(v_Color);\r\n #else\r\n inkColor *= v_Color;\r\n #endif\r\n#endif\r\n\r\n vec3 N = v_Normal;\r\n#ifdef DOUBLE_SIDED\r\n vec3 eyePos = viewInverse[3].xyz;\r\n vec3 V = normalize(eyePos - v_WorldPosition);\r\n\r\n if (dot(N, V) < 0.0) {\r\n N = -N;\r\n }\r\n#endif\r\n\r\n float tone = 0.0;\r\n\r\n float ambientFactor = 1.0;\r\n\r\n#ifdef BUMPMAP_ENABLED\r\n N = bumpNormal(v_WorldPosition, v_Normal, N);\r\n // PENDING\r\n ambientFactor = dot(v_Normal, N);\r\n#endif\r\n\r\n vec3 N2 = vec3(N.x, N[NORMAL_UP_AXIS], N[NORMAL_FRONT_AXIS]);\r\n\r\n @import ecgl.common.ssaoMap.main\r\n\r\n#ifdef AMBIENT_LIGHT_COUNT\r\n for(int i = 0; i < AMBIENT_LIGHT_COUNT; i++)\r\n {\r\n // Multiply a dot factor to make sure the bump detail can be seen\r\n // in the dark side\r\n tone += dot(ambientLightColor[i], w) * ambientFactor * ao;\r\n }\r\n#endif\r\n#ifdef AMBIENT_SH_LIGHT_COUNT\r\n for(int _idx_ = 0; _idx_ < AMBIENT_SH_LIGHT_COUNT; _idx_++)\r\n {{\r\n tone += dot(calcAmbientSHLight(_idx_, N2) * ambientSHLightColor[_idx_], w) * ao;\r\n }}\r\n#endif\r\n#ifdef DIRECTIONAL_LIGHT_COUNT\r\n#if defined(DIRECTIONAL_LIGHT_SHADOWMAP_COUNT)\r\n float shadowContribsDir[DIRECTIONAL_LIGHT_COUNT];\r\n if(shadowEnabled)\r\n {\r\n computeShadowOfDirectionalLights(v_WorldPosition, shadowContribsDir);\r\n }\r\n#endif\r\n for(int i = 0; i < DIRECTIONAL_LIGHT_COUNT; i++)\r\n {\r\n vec3 lightDirection = -directionalLightDirection[i];\r\n float lightTone = dot(directionalLightColor[i], w);\r\n\r\n float shadowContrib = 1.0;\r\n#if defined(DIRECTIONAL_LIGHT_SHADOWMAP_COUNT)\r\n if (shadowEnabled)\r\n {\r\n shadowContrib = shadowContribsDir[i];\r\n }\r\n#endif\r\n\r\n float ndl = dot(N, normalize(lightDirection)) * shadowContrib;\r\n\r\n tone += lightTone * clamp(ndl, 0.0, 1.0);\r\n }\r\n#endif\r\n\r\n gl_FragColor = mix(inkColor, paperColor, shade(clamp(tone, 0.0, 1.0)));\r\n // gl_FragColor = vec4(vec3(clamp(tone, 0.0, 1.0)), 1.0);\r\n}\r\n@end\r\n";