export default "@export ecgl.normal.vertex\r\n\r\n@import ecgl.common.transformUniforms\r\n\r\n@import ecgl.common.uv.header\r\n\r\n@import ecgl.common.attributes\r\n\r\nvarying vec3 v_Normal;\r\nvarying vec3 v_WorldPosition;\r\n\r\n@import ecgl.common.normalMap.vertexHeader\r\n\r\n@import ecgl.common.vertexAnimation.header\r\n\r\nvoid main()\r\n{\r\n\r\n // TODO Animation\r\n @import ecgl.common.vertexAnimation.main\r\n\r\n @import ecgl.common.uv.main\r\n\r\n v_Normal = normalize((worldInverseTranspose * vec4(normal, 0.0)).xyz);\r\n v_WorldPosition = (world * vec4(pos, 1.0)).xyz;\r\n\r\n @import ecgl.common.normalMap.vertexMain\r\n\r\n gl_Position = worldViewProjection * vec4(pos, 1.0);\r\n\r\n}\r\n\r\n\r\n@end\r\n\r\n\r\n@export ecgl.normal.fragment\r\n\r\n#define ROUGHNESS_CHANEL 0\r\n\r\nuniform bool useBumpMap;\r\nuniform bool useRoughnessMap;\r\nuniform bool doubleSide;\r\nuniform float roughness;\r\n\r\n@import ecgl.common.uv.fragmentHeader\r\n\r\nvarying vec3 v_Normal;\r\nvarying vec3 v_WorldPosition;\r\n\r\nuniform mat4 viewInverse : VIEWINVERSE;\r\n\r\n@import ecgl.common.normalMap.fragmentHeader\r\n@import ecgl.common.bumpMap.header\r\n\r\nuniform sampler2D roughnessMap;\r\n\r\nvoid main()\r\n{\r\n vec3 N = v_Normal;\r\n \r\n bool flipNormal = false;\r\n if (doubleSide) {\r\n vec3 eyePos = viewInverse[3].xyz;\r\n vec3 V = normalize(eyePos - v_WorldPosition);\r\n\r\n if (dot(N, V) < 0.0) {\r\n flipNormal = true;\r\n }\r\n }\r\n\r\n @import ecgl.common.normalMap.fragmentMain\r\n\r\n if (useBumpMap) {\r\n N = bumpNormal(v_WorldPosition, v_Normal, N);\r\n }\r\n\r\n float g = 1.0 - roughness;\r\n\r\n if (useRoughnessMap) {\r\n float g2 = 1.0 - texture2D(roughnessMap, v_DetailTexcoord)[ROUGHNESS_CHANEL];\r\n // Adjust the brightness\r\n g = clamp(g2 + (g - 0.5) * 2.0, 0.0, 1.0);\r\n }\r\n\r\n if (flipNormal) {\r\n N = -N;\r\n }\r\n\r\n gl_FragColor.rgb = (N.xyz + 1.0) * 0.5;\r\n gl_FragColor.a = g;\r\n}\r\n@end";